package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.client._

/** Pointer for ContainerResourceMetricSource */
final case class ContainerResourceMetricSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource] {
  def container : Pointer.Plain[String] = Pointer.Plain(currentPath / s"container")
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def target :  io.k8s.api.autoscaling.v2.MetricTargetPointer = io.k8s.api.autoscaling.v2.MetricTargetPointer(currentPath / s"target")
}


