package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.client._

/** Pointer for SubjectAccessReviewSpec */
final case class SubjectAccessReviewSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authorization.v1.SubjectAccessReviewSpec] {
  def groups : ListPointer[String] = ListPointer(currentPath / s"groups")
  def resourceAttributes :  io.k8s.api.authorization.v1.ResourceAttributesPointer = io.k8s.api.authorization.v1.ResourceAttributesPointer(currentPath / s"resourceAttributes")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def extra : MapPointer[Seq[String]] = MapPointer(currentPath / s"extra")
  def user : Pointer.Plain[String] = Pointer.Plain(currentPath / s"user")
  def nonResourceAttributes :  io.k8s.api.authorization.v1.NonResourceAttributesPointer = io.k8s.api.authorization.v1.NonResourceAttributesPointer(currentPath / s"nonResourceAttributes")
}


