package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.client._

/** Pointer for ResourceAttributes */
final case class ResourceAttributesPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authorization.v1.ResourceAttributes] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def version : Pointer.Plain[String] = Pointer.Plain(currentPath / s"version")
  def resource : Pointer.Plain[String] = Pointer.Plain(currentPath / s"resource")
  def verb : Pointer.Plain[String] = Pointer.Plain(currentPath / s"verb")
  def group : Pointer.Plain[String] = Pointer.Plain(currentPath / s"group")
  def subresource : Pointer.Plain[String] = Pointer.Plain(currentPath / s"subresource")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
}


