package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for ControllerRevision */
final case class ControllerRevisionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.ControllerRevision] {
  def revision : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"revision")
  def data : Pointer.Plain[io.k8s.apimachinery.pkg.runtime.RawExtension] = Pointer.Plain(currentPath / s"data")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


