package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.client._

/** Pointer for ParamRef */
final case class ParamRefPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.admissionregistration.v1alpha1.ParamRef] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
  def parameterNotFoundAction : Pointer.Plain[String] = Pointer.Plain(currentPath / s"parameterNotFoundAction")
  def selector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
}


