/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ConfigList<Item> {
    public Collection<Item> getDisabledOptions();

    public Collection<Item> getUsedOptions();

    public boolean shouldAllDefaultsBeDisabled();

    public static abstract class Processor<Item> {
        private final Collection<Item> defaults;
        private ConfigList<Item> config;

        public Processor(Collection<Item> defaults) {
            this(null, defaults);
        }

        public Processor(ConfigList<Item> config, Collection<Item> defaults) {
            this.config = config;
            this.defaults = defaults;
        }

        public ConfigList<Item> getConfig() {
            return this.config;
        }

        public void setConfig(ConfigList<Item> config) {
            this.config = config;
        }

        public Collection<Item> getDefaults() {
            return this.defaults;
        }

        public Collection<Item> process() {
            if (this.config == null) {
                return this.defaults;
            }
            Stream<Object> stream = Objects.requireNonNull(this.config).getUsedOptions().stream();
            if (!this.config.shouldAllDefaultsBeDisabled()) {
                stream = Stream.concat(this.defaults.stream().filter(plugin -> !this.config.getDisabledOptions().contains(plugin)), stream);
            }
            return Collections.unmodifiableCollection(stream.collect(Collectors.toSet()));
        }
    }
}

