/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.logging;

import dev.gradleplugins.runnerkit.ActionableTaskCount;
import dev.gradleplugins.runnerkit.BuildFailures;
import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.BuildResultImpl;
import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.CommandLineToolLogContent;
import dev.gradleplugins.runnerkit.TaskPath;
import dev.gradleplugins.runnerkit.logging.CommandLineToolLogContentLineVisitorAdapter;
import dev.gradleplugins.runnerkit.logging.OutputScrappingBuildLogVisitor;
import dev.gradleplugins.runnerkit.logging.TaskOutputGroupingVisitor;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public final class GradleLogContentUtils {
    private GradleLogContentUtils() {
    }

    public static Consumer<CommandLineToolLogContent.LineDetails> normalizedBuildResult() {
        return BuildResultNormalizer.INSTANCE;
    }

    public static Consumer<CommandLineToolLogContent.LineDetails> removedWarningSummaryMessage() {
        return WarningSummaryMessageNormalizer.INSTANCE;
    }

    public static Consumer<CommandLineToolLogContent.LineDetails> removedDaemonMessage() {
        return GradleDaemonMessageNormalizer.INSTANCE;
    }

    public static Consumer<CommandLineToolLogContent.LineDetails> removedJavaIllegalAccessWarnings() {
        return JavaIllegalAccessWarningsNormalizer.INSTANCE;
    }

    public static CommandLineToolLogContent normalize(CommandLineToolLogContent content) {
        return content.withAnsiControlCharactersInterpreted().withNormalizedEndOfLine().visitEachLine(GradleLogContentUtils.removedJavaIllegalAccessWarnings()).visitEachLine(GradleLogContentUtils.removedDaemonMessage()).visitEachLine(GradleLogContentUtils.removedWarningSummaryMessage()).visitEachLine(GradleLogContentUtils.normalizedBuildResult());
    }

    public static BuildResult scrapBuildResultFrom(String output) {
        return GradleLogContentUtils.scrapBuildResultFrom(CommandLineToolLogContent.of(output));
    }

    public static BuildResult scrapBuildResultFrom(CommandLineToolLogContent output) {
        CommandLineToolLogContent normalizedOutput = GradleLogContentUtils.normalize(output);
        OutputScrappingBuildLogVisitor visitor = new OutputScrappingBuildLogVisitor();
        normalizedOutput.visitEachLine(new CommandLineToolLogContentLineVisitorAdapter(new TaskOutputGroupingVisitor(visitor)));
        Map<TaskPath, BuildTask> discoveredTasks = visitor.getDiscoveredTasks();
        ActionableTaskCount actionableTaskCount = visitor.getActionableTaskCount().orElseGet(() -> ActionableTaskCount.from(discoveredTasks));
        return new BuildResultImpl(discoveredTasks, normalizedOutput, actionableTaskCount, visitor.getBuildOutcome(), BuildFailures.from(normalizedOutput));
    }

    private static enum JavaIllegalAccessWarningsNormalizer implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;


        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            if (details.getLine().startsWith("WARNING: An illegal reflective access operation has occurred") || details.getLine().equals("WARNING: All illegal access operations will be denied in a future release")) {
                details.dropLine();
            }
        }
    }

    private static enum GradleDaemonMessageNormalizer implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;

        static final String STARTING_DAEMON_MESSAGE = "Starting a Gradle Daemon";
        static final String DAEMON_WILL_STOP_MESSAGE = "Daemon will be stopped at the end of the build ";
        static final String EXPIRE_DAEMON_MESSAGE = "Expiring Daemon because JVM heap space is exhausted";

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            String line = details.getLine();
            if (line.contains(STARTING_DAEMON_MESSAGE)) {
                details.dropLine();
            } else if (line.contains(DAEMON_WILL_STOP_MESSAGE)) {
                details.dropLine();
            } else if (line.contains(EXPIRE_DAEMON_MESSAGE)) {
                details.dropLine();
            }
        }
    }

    private static enum WarningSummaryMessageNormalizer implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;

        private static final String WARNING_SUMMARY = "Deprecated Gradle features were used in this build, making it incompatible with Gradle";

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            if (details.getLine().contains(WARNING_SUMMARY)) {
                details.drop(4);
            }
        }
    }

    private static enum BuildResultNormalizer implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;

        private static final Pattern BUILD_RESULT_PATTERN;

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            if (BUILD_RESULT_PATTERN.matcher(details.getLine()).matches()) {
                details.replaceWith(BUILD_RESULT_PATTERN.matcher(details.getLine()).replaceFirst("BUILD $1"));
            }
        }

        static {
            BUILD_RESULT_PATTERN = Pattern.compile("BUILD (SUCCESSFUL|FAILED) in( \\d+m?[smh])+");
        }
    }
}

