/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildTaskImpl;
import dev.gradleplugins.runnerkit.TaskOutcome;
import dev.gradleplugins.runnerkit.TaskPath;
import java.util.Objects;

public final class BuildTaskBuilder {
    private TaskOutcome outcome = TaskOutcome.SUCCESS;
    private TaskPath path;
    private final StringBuilder outputBuilder = new StringBuilder();

    private BuildTaskBuilder() {
    }

    public static BuildTaskBuilder newBuilder() {
        return new BuildTaskBuilder();
    }

    public BuildTaskBuilder withOutcome(TaskOutcome outcome) {
        this.outcome = outcome;
        return this;
    }

    public BuildTaskBuilder withPath(TaskPath path) {
        this.path = path;
        return this;
    }

    public BuildTaskBuilder appendToOutput(String output) {
        this.outputBuilder.append(output);
        return this;
    }

    public BuildTaskImpl build() {
        return new BuildTaskImpl(Objects.requireNonNull(this.path), this.outcome, this.outputBuilder.toString());
    }
}

