/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.fixtures.file.FilePreconditions;
import dev.gradleplugins.runnerkit.CommandLineToolLogContent;
import dev.gradleplugins.runnerkit.GradleDistribution;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.GradleRunner;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.distributions.DownloadableGradleDistribution;
import dev.gradleplugins.runnerkit.distributions.LocalGradleDistribution;
import dev.gradleplugins.runnerkit.distributions.VersionAwareGradleDistribution;
import dev.gradleplugins.runnerkit.distributions.WrapperAwareGradleDistribution;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.util.GradleVersion;

public final class GradleDistributionProvider
extends AbstractGradleExecutionProvider<GradleDistribution> {
    public static GradleDistributionProvider fromGradleRunner() {
        return GradleDistributionProvider.supplied(GradleDistributionProvider.class, () -> GradleDistributionProvider.findGradleInstallFromGradleRunner());
    }

    static GradleDistribution findGradleInstallFromGradleRunner() {
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        if (gradleInstallation == null) {
            String messagePrefix = "Could not find a Gradle installation to use based on the location of the GradleRunner class";
            try {
                File classpathForClass = ClasspathUtil.getClasspathForClass(GradleRunner.class);
                messagePrefix = messagePrefix + ": " + classpathForClass.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new InvalidRunnerConfigurationException(messagePrefix + ". Please specify a Gradle runtime to use via GradleRunner.withGradleVersion() or similar.");
        }
        return new GradleDistributionInstallationImpl(gradleInstallation.getGradleHome());
    }

    public static GradleVersion findVersion(CommandLineToolLogContent output) {
        return GradleVersion.version((String)output.getLines().stream().filter(it -> it.startsWith("Gradle ")).map((? super T it) -> it.replace("Gradle ", "")).findFirst().orElseThrow(RuntimeException::new));
    }

    public static GradleDistributionProvider fromWrapper(Supplier<File> baseDirectory) {
        return GradleDistributionProvider.supplied(GradleDistributionProvider.class, () -> new GradleDistributionWrapperImpl((File)baseDirectory.get()));
    }

    public static GradleDistributionProvider fromGradleWrapper() {
        return GradleDistributionProvider.calculated(GradleDistributionProvider.class, context -> new GradleDistributionWrapperImpl((File)context.getWorkingDirectory().get()));
    }

    public static GradleDistributionProvider fromGradleWrapper(File baseDirectory) {
        return GradleDistributionProvider.fixed(GradleDistributionProvider.class, new GradleDistributionWrapperImpl(baseDirectory));
    }

    public static GradleDistributionProvider executorDefault() {
        return GradleDistributionProvider.calculated(GradleDistributionProvider.class, new Function<GradleExecutionContext, GradleDistribution>(){

            @Override
            public GradleDistribution apply(GradleExecutionContext context) {
                if (this.isGradleWrapperExecutor(context.getExecutorType())) {
                    return new GradleDistributionWrapperImpl((File)context.getWorkingDirectory().get());
                }
                return new GradleDistributionVersionImpl(GradleVersion.current().getVersion());
            }

            private boolean isGradleWrapperExecutor(Class<? extends GradleExecutor> type) {
                return type.getSimpleName().contains("Wrapper");
            }
        });
    }

    private static GradleDistributionProvider current() {
        return GradleDistributionProvider.version(GradleVersion.current().getVersion());
    }

    public static GradleDistributionProvider version(String versionNumber) {
        return GradleDistributionProvider.fixed(GradleDistributionProvider.class, new GradleDistributionVersionImpl(versionNumber));
    }

    private static GradleDistribution ofVersion(String version) {
        return new GradleDistributionVersionImpl(version);
    }

    public static GradleDistributionProvider installation(File installation) {
        return GradleDistributionProvider.fixed(GradleDistributionProvider.class, new GradleDistributionInstallationImpl(installation));
    }

    public static GradleDistributionProvider uri(URI distribution) {
        return GradleDistributionProvider.fixed(GradleDistributionProvider.class, new GradleDistributionUriImpl(distribution));
    }

    private static final class GradleDistributionWrapperImpl
    implements WrapperAwareGradleDistribution {
        private static final Pattern DISTRIBUTION_URL_VERSION_PATTERN = Pattern.compile("(\\d+.\\d+(.\\d+)?(-rc-\\d)?)");
        private final File rootProjectDirectory;

        public GradleDistributionWrapperImpl(File rootProjectDirectory) {
            FilePreconditions.checkIsDirectory((File)rootProjectDirectory, (String)"Invalid project directory");
            this.assertWrapperInstalled(rootProjectDirectory);
            this.rootProjectDirectory = rootProjectDirectory;
        }

        private void assertWrapperInstalled(File rootProjectDirectory) {
            boolean expectedWrapperFilesExists = Stream.of(new File(rootProjectDirectory, "gradlew"), new File(rootProjectDirectory, "gradlew.bat"), new File(rootProjectDirectory, "gradle/wrapper/gradle-wrapper.properties"), new File(rootProjectDirectory, "gradle/wrapper/gradle-wrapper.jar")).allMatch(File::exists);
            if (!expectedWrapperFilesExists) {
                throw new IllegalArgumentException(String.format("Invalid wrapper distribution at '%s'.", rootProjectDirectory.getAbsolutePath()));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getVersion() {
            File wrapperPropertiesFile = new File(this.rootProjectDirectory, "gradle/wrapper/gradle-wrapper.properties");
            try (FileInputStream inStream = new FileInputStream(wrapperPropertiesFile);){
                Properties wrapperProperties = new Properties();
                wrapperProperties.load(inStream);
                String distributionUrl = Optional.ofNullable(wrapperProperties.getProperty("distributionUrl")).orElseThrow(() -> new IllegalArgumentException(String.format("Unable to retrive 'distributionUrl' property from '%s'.", wrapperPropertiesFile.getAbsolutePath())));
                Matcher matcher = DISTRIBUTION_URL_VERSION_PATTERN.matcher(distributionUrl);
                if (matcher.find()) {
                    String string = matcher.group(1);
                    return string;
                }
                throw new UnsupportedOperationException(String.format("Unsupported distribution URL format '%s'.", distributionUrl));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(String.format("Unable to locate gradle-wrapper.properties inside project '%s'.", this.rootProjectDirectory.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public File getRootProjectDirectory() {
            return this.rootProjectDirectory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleDistributionWrapperImpl)) {
                return false;
            }
            GradleDistributionWrapperImpl other = (GradleDistributionWrapperImpl)o;
            File this$rootProjectDirectory = this.getRootProjectDirectory();
            File other$rootProjectDirectory = other.getRootProjectDirectory();
            return !(this$rootProjectDirectory == null ? other$rootProjectDirectory != null : !((Object)this$rootProjectDirectory).equals(other$rootProjectDirectory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $rootProjectDirectory = this.getRootProjectDirectory();
            result = result * 59 + ($rootProjectDirectory == null ? 43 : ((Object)$rootProjectDirectory).hashCode());
            return result;
        }

        public String toString() {
            return "GradleDistributionProvider.GradleDistributionWrapperImpl(rootProjectDirectory=" + this.getRootProjectDirectory() + ")";
        }
    }

    private static final class GradleDistributionUriImpl
    implements DownloadableGradleDistribution {
        private final URI uri;

        public GradleDistributionUriImpl(URI uri) {
            this.uri = uri;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleDistributionUriImpl)) {
                return false;
            }
            GradleDistributionUriImpl other = (GradleDistributionUriImpl)o;
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            return result;
        }

        public String toString() {
            return "GradleDistributionProvider.GradleDistributionUriImpl(uri=" + this.getUri() + ")";
        }
    }

    private static final class GradleDistributionInstallationImpl
    implements LocalGradleDistribution {
        private final File installationDirectory;

        public GradleDistributionInstallationImpl(File installationDirectory) {
            this.installationDirectory = installationDirectory;
        }

        @Override
        public File getInstallationDirectory() {
            return this.installationDirectory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleDistributionInstallationImpl)) {
                return false;
            }
            GradleDistributionInstallationImpl other = (GradleDistributionInstallationImpl)o;
            File this$installationDirectory = this.getInstallationDirectory();
            File other$installationDirectory = other.getInstallationDirectory();
            return !(this$installationDirectory == null ? other$installationDirectory != null : !((Object)this$installationDirectory).equals(other$installationDirectory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $installationDirectory = this.getInstallationDirectory();
            result = result * 59 + ($installationDirectory == null ? 43 : ((Object)$installationDirectory).hashCode());
            return result;
        }

        public String toString() {
            return "GradleDistributionProvider.GradleDistributionInstallationImpl(installationDirectory=" + this.getInstallationDirectory() + ")";
        }
    }

    private static final class GradleDistributionVersionImpl
    implements VersionAwareGradleDistribution {
        private final String version;

        public GradleDistributionVersionImpl(String version) {
            this.version = version;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleDistributionVersionImpl)) {
                return false;
            }
            GradleDistributionVersionImpl other = (GradleDistributionVersionImpl)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "GradleDistributionProvider.GradleDistributionVersionImpl(version=" + this.getVersion() + ")";
        }
    }
}

