/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.ansi;

import net.rubygrapefruit.ansi.TextColor;
import net.rubygrapefruit.ansi.Visitor;
import net.rubygrapefruit.ansi.token.BackgroundColor;
import net.rubygrapefruit.ansi.token.BoldOff;
import net.rubygrapefruit.ansi.token.BoldOn;
import net.rubygrapefruit.ansi.token.ForegroundColor;
import net.rubygrapefruit.ansi.token.Token;

public class NormalizingVisitor
implements Visitor {
    private final Visitor visitor;
    private boolean forwardedBold;
    private boolean bold;
    private TextColor forwardedColor = TextColor.DEFAULT;
    private TextColor color = TextColor.DEFAULT;
    private TextColor forwardedBackground = TextColor.DEFAULT;
    private TextColor background = TextColor.DEFAULT;

    private NormalizingVisitor(Visitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public void visit(Token token) {
        if (token instanceof BoldOn) {
            this.bold = true;
        } else if (token instanceof BoldOff) {
            this.bold = false;
        } else if (token instanceof ForegroundColor) {
            ForegroundColor colorToken = (ForegroundColor)token;
            this.color = colorToken.getColor();
        } else if (token instanceof BackgroundColor) {
            BackgroundColor colorToken = (BackgroundColor)token;
            this.background = colorToken.getColor();
        } else {
            if (this.bold && !this.forwardedBold) {
                this.visitor.visit(BoldOn.INSTANCE);
                this.forwardedBold = true;
            } else if (!this.bold && this.forwardedBold) {
                this.visitor.visit(BoldOff.INSTANCE);
                this.forwardedBold = false;
            }
            if (!this.color.equals(this.forwardedColor)) {
                this.visitor.visit(ForegroundColor.of(this.color));
                this.forwardedColor = this.color;
            }
            if (!this.background.equals(this.forwardedBackground)) {
                this.visitor.visit(BackgroundColor.of(this.background));
                this.forwardedBackground = this.background;
            }
            this.visitor.visit(token);
        }
    }

    public void endStream() {
        if (this.forwardedBold) {
            this.visitor.visit(BoldOff.INSTANCE);
            this.forwardedBold = false;
        }
        if (!this.forwardedColor.isDefault()) {
            this.visitor.visit(ForegroundColor.DEFAULT);
            this.forwardedColor = null;
        }
        if (!this.forwardedBackground.isDefault()) {
            this.visitor.visit(BackgroundColor.DEFAULT);
            this.forwardedBackground = null;
        }
    }

    public static NormalizingVisitor of(Visitor visitor) {
        if (visitor instanceof NormalizingVisitor) {
            return (NormalizingVisitor)visitor;
        }
        return new NormalizingVisitor(visitor);
    }
}

