/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionJvmSystemPropertyProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DaemonIdleTimeoutProvider
extends AbstractGradleExecutionProvider<Duration>
implements GradleExecutionJvmSystemPropertyProvider {
    static final Duration DEFAULT_TEST_KIT_DAEMON_IDLE_TIMEOUT = Duration.ofSeconds(120L);
    static final String DAEMON_BUILD_OPTIONS_IDLE_TIMEOUT_OPTION_GRADLE_PROPERTY = "org.gradle.daemon.idletimeout";

    public static DaemonIdleTimeoutProvider testKitIdleTimeout() {
        return DaemonIdleTimeoutProvider.fixed(DaemonIdleTimeoutProvider.class, DEFAULT_TEST_KIT_DAEMON_IDLE_TIMEOUT);
    }

    public static DaemonIdleTimeoutProvider of(Duration daemonIdleTimeout) {
        return DaemonIdleTimeoutProvider.fixed(DaemonIdleTimeoutProvider.class, daemonIdleTimeout);
    }

    @Override
    public Map<String, String> getAsJvmSystemProperties() {
        return Collections.singletonMap(DAEMON_BUILD_OPTIONS_IDLE_TIMEOUT_OPTION_GRADLE_PROPERTY, String.valueOf(((Duration)this.get()).toMillis()));
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("-Dorg.gradle.daemon.idletimeout"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#withDaemonIdleTimeout(Duration) instead of using the command line flags.");
        }
    }
}

