/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.logging;

import dev.gradleplugins.runnerkit.ActionableTaskCount;
import dev.gradleplugins.runnerkit.BuildOutcome;
import dev.gradleplugins.runnerkit.TaskOutcomeUtils;
import dev.gradleplugins.runnerkit.TaskPath;
import dev.gradleplugins.runnerkit.logging.BuildLogVisitor;
import dev.nokee.core.exec.CommandLineToolLogContent;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommandLineToolLogContentLineVisitorAdapter
implements Consumer<CommandLineToolLogContent.LineDetails> {
    private static final Pattern TASK_PATTERN = Pattern.compile("(> Task )?(:\\S+)\\s*(SKIPPED|UP-TO-DATE|FROM-CACHE|NO-SOURCE|FAILED)?");
    private static final Pattern ACTIONABLE_TASKS_PATTERN = Pattern.compile("(\\d+) actionable tasks?: (\\d+) executed(, (\\d+) up-to-date)?");
    private final BuildLogVisitor visitor;

    public CommandLineToolLogContentLineVisitorAdapter(BuildLogVisitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public void accept(CommandLineToolLogContent.LineDetails details) {
        Matcher matches = TASK_PATTERN.matcher(details.getLine());
        if (matches.matches()) {
            String taskPath = matches.group(2);
            String taskOutcome = matches.group(3);
            if (taskOutcome == null) {
                this.visitor.visitTaskHeader(TaskPath.of((String)taskPath));
            } else {
                this.visitor.visitTaskHeader(TaskPath.of((String)taskPath), TaskOutcomeUtils.from(taskOutcome));
            }
        } else if (details.getLine().startsWith("FAILURE: ")) {
            this.visitor.visitBuildFailure();
        } else if (details.getLine().equals("BUILD SUCCESSFUL")) {
            this.visitor.visitBuildResult(BuildOutcome.SUCCESSFUL);
        } else if (details.getLine().equals("BUILD FAILED")) {
            this.visitor.visitBuildResult(BuildOutcome.FAILED);
        } else if (ACTIONABLE_TASKS_PATTERN.matcher(details.getLine()).matches()) {
            int upToDateTaskCount;
            Matcher m = ACTIONABLE_TASKS_PATTERN.matcher(details.getLine());
            m.matches();
            int actionableTaskCount = Integer.parseInt(m.group(1));
            int executedTaskCount = Integer.parseInt(m.group(2));
            int n = upToDateTaskCount = m.group(4) != null ? Integer.parseInt(m.group(4)) : 0;
            assert (actionableTaskCount == executedTaskCount + upToDateTaskCount);
            this.visitor.visitActionableTasks(ActionableTaskCount.of(executedTaskCount, upToDateTaskCount));
        } else {
            this.visitor.visitContentLine(details.getLine());
        }
    }
}

