/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils.internal;

import dev.nokee.utils.DeferredUtils;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;

public class DeleteDirectoriesTaskAction
implements Action<Task> {
    private final Iterable<Object> directories;

    public void execute(Task task) {
        DeferredUtils.flatUnpackUntil(this.directories, this::unpackToFile, File.class).forEach(this::deleteDirectory);
    }

    private void deleteDirectory(File directory) {
        FileUtils.deleteDirectory(directory);
    }

    private Object unpackToFile(Object obj) {
        if ((obj = DeferredUtils.unpack(obj)) instanceof Directory) {
            return ((Directory)obj).getAsFile();
        }
        if (obj instanceof Path) {
            return ((Path)obj).toFile();
        }
        return obj;
    }

    public DeleteDirectoriesTaskAction(Iterable<Object> directories) {
        this.directories = directories;
    }
}

