/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.provider.Provider;
import org.gradle.util.GUtil;

public final class DeferredUtils {
    private static final Optional<Class<?>> KOTLIN_FUNCTION0_CLASS = DeferredUtils.loadKotlinFunction0Class();

    @Nullable
    public static Object unpack(@Nullable Object deferred) {
        if (deferred == null) {
            return null;
        }
        Object value = DeferredUtils.unpackNestableDeferred(deferred);
        if (value instanceof Provider) {
            return ((Provider)value).get();
        }
        return value;
    }

    public static <T> List<T> flatUnpackUntil(@Nullable Object deferred, Class<T> type) {
        return DeferredUtils.flatUnpackUntil(deferred, DeferredUtils::flatten, DeferredUtils::unpack, type);
    }

    public static <T> List<T> flatUnpackUntil(@Nullable Object deferred, UnaryOperator<Object> unpacker, Class<T> type) {
        return DeferredUtils.flatUnpackUntil(deferred, DeferredUtils::flatten, unpacker, type);
    }

    public static <T> List<T> flatUnpackUntil(@Nullable Object deferred, BiFunction<Object, Deque<Object>, Boolean> flatter, UnaryOperator<Object> unpacker, Class<T> type) {
        return DeferredUtils.flatUnpackWhile(deferred, flatter, it -> unpacker.apply(DeferredUtils.unpack(it)), it -> {
            if (DeferredUtils.isFlattenableType(it)) {
                return false;
            }
            if (DeferredUtils.isNestableDeferred(it)) {
                return true;
            }
            return !type.isInstance(it);
        });
    }

    public static List<Object> flatUnpack(@Nullable Object deferred) {
        return DeferredUtils.flatUnpackWhile(deferred, DeferredUtils::flatten, DeferredUtils::unpack, DeferredUtils::isNestableDeferred);
    }

    public static List<Object> flatUnpackWhile(@Nullable Object deferred, Predicate<Object> predicate) {
        return DeferredUtils.flatUnpackWhile(deferred, DeferredUtils::flatten, DeferredUtils::unpack, Objects.requireNonNull(predicate));
    }

    public static List<Object> flatUnpackWhile(@Nullable Object deferred, UnaryOperator<Object> unpacker, Predicate<Object> predicate) {
        return DeferredUtils.flatUnpackWhile(deferred, DeferredUtils::flatten, Objects.requireNonNull(unpacker), Objects.requireNonNull(predicate));
    }

    public static List<Object> flatUnpackWhile(@Nullable Object deferred, BiFunction<Object, Deque<Object>, Boolean> flatter, UnaryOperator<Object> unpacker, Predicate<Object> predicate) {
        if (deferred == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.addFirst(deferred);
        while (!queue.isEmpty()) {
            Object value = queue.removeFirst();
            if (predicate.test(value)) {
                queue.addFirst(unpacker.apply(value));
                continue;
            }
            int sizeBefore = queue.size();
            Boolean didFlat = flatter.apply(value, queue);
            if (sizeBefore > queue.size()) {
                throw new IllegalStateException("Flatter consumer cannot remove items from the queue");
            }
            if (didFlat.booleanValue()) continue;
            result.add(value);
        }
        return result.build();
    }

    static boolean flatten(Object value, Deque<Object> queue) {
        if (value instanceof List) {
            List list = (List)value;
            if (list instanceof RandomAccess) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    queue.addFirst(list.get(i));
                }
            } else {
                ListIterator iterator = list.listIterator(list.size());
                while (iterator.hasPrevious()) {
                    Object item = iterator.previous();
                    queue.addFirst(item);
                }
            }
            return true;
        }
        if (value instanceof Set) {
            ((Set)value).forEach(queue::addFirst);
            return true;
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            DeferredUtils.addAllFirst(queue, array);
            return true;
        }
        return false;
    }

    static boolean isFlattenableType(Object value) {
        return value instanceof List || value instanceof Set || value instanceof Object[];
    }

    private static void addAllFirst(Deque<Object> queue, Object[] items) {
        for (int i = items.length - 1; i >= 0; --i) {
            queue.addFirst(items[i]);
        }
    }

    static boolean isDeferred(Object value) {
        return value instanceof Provider || DeferredUtils.isNestableDeferred(value);
    }

    static boolean isNestableDeferred(@Nullable Object value) {
        return value instanceof Callable || value instanceof Supplier || DeferredUtils.isKotlinFunction0Deferrable(value);
    }

    @Nullable
    static Object unpackNestableDeferred(Object deferred) {
        Object current = deferred;
        while (DeferredUtils.isNestableDeferred(current)) {
            if (current instanceof Callable) {
                current = GUtil.uncheckedCall((Callable)((Callable)current));
                continue;
            }
            if (current instanceof Supplier) {
                current = ((Supplier)current).get();
                continue;
            }
            current = DeferredUtils.unpackKotlinFunction0(current);
        }
        return current;
    }

    private static boolean isKotlinFunction0Deferrable(@Nullable Object value) {
        return KOTLIN_FUNCTION0_CLASS.map(it -> it.isAssignableFrom(value.getClass())).orElse(false);
    }

    @Nullable
    private static Object unpackKotlinFunction0(Object value) {
        try {
            return KOTLIN_FUNCTION0_CLASS.orElseThrow(() -> new RuntimeException("kotlin.jvm.functions.Function0 not found in classpath.")).getMethod("invoke", new Class[0]).invoke(value, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Could not access kotlin.jvm.functions.Function0#invoke() method on object of type '%s'.", value.getClass().getCanonicalName()), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Could not invoke kotlin.jvm.functions.Function0#invoke() method on object of type '%s'.", value.getClass().getCanonicalName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Could not find kotlin.jvm.functions.Function0#invoke() method on object of type '%s'.", value.getClass().getCanonicalName()), e);
        }
    }

    private static Optional<Class<?>> loadKotlinFunction0Class() {
        try {
            return Optional.of(Class.forName("kotlin.jvm.functions.Function0"));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static <T> void realize(DomainObjectCollection<T> collection) {
        Iterator iter = collection.iterator();
        if (iter.hasNext()) {
            iter.next();
        }
    }
}

