/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.internal.AbstractCommandLineTool;
import java.io.File;
import java.util.Optional;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.os.OperatingSystem;

final class CommandLineTools {
    private CommandLineTools() {
    }

    public static Optional<CommandLineTool> findInPath(String executable) {
        return Optional.ofNullable(OperatingSystem.current().findInPath(executable)).map(CommandLineTools::fromLocation);
    }

    public static CommandLineTool fromPath(Object executable) {
        return new CommandLineToolFromPathAtInvocationImpl(executable);
    }

    public static CommandLineTool fromLocation(File executable) {
        return new CommandLineToolFromFileSystemLocationImpl(executable);
    }

    private static final class CommandLineToolFromFileSystemLocationImpl
    extends AbstractCommandLineTool {
        private final File toolLocation;

        private CommandLineToolFromFileSystemLocationImpl(File toolLocation) {
            this.toolLocation = toolLocation;
        }

        @Override
        @Internal
        public String getExecutable() {
            return this.toolLocation.getAbsolutePath();
        }

        @InputFile
        @PathSensitive(value=PathSensitivity.NONE)
        protected File getInputFile() {
            return this.toolLocation;
        }
    }

    private static final class CommandLineToolFromPathAtInvocationImpl
    extends AbstractCommandLineTool {
        private final Object executable;

        private CommandLineToolFromPathAtInvocationImpl(Object executable) {
            this.executable = executable;
        }

        @Override
        @Input
        public String getExecutable() {
            return this.executable.toString();
        }
    }
}

