/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.logging;

import dev.gradleplugins.runnerkit.BuildOutcome;
import dev.gradleplugins.runnerkit.TaskOutcome;
import dev.gradleplugins.runnerkit.TaskPath;
import dev.gradleplugins.runnerkit.logging.BuildLogVisitor;
import dev.gradleplugins.runnerkit.logging.CurrentTaskAwareBuildLogVisitorAdapter;

public final class TaskOutputGroupingVisitor
extends CurrentTaskAwareBuildLogVisitorAdapter {
    private String previousLine = null;
    private boolean hasOutputSinceHeader = false;

    public TaskOutputGroupingVisitor(BuildLogVisitor delegate) {
        super(delegate);
    }

    private void flushTaskOutput() {
        if (this.previousLine != null) {
            if (this.previousLine.isEmpty()) {
                if (this.hasOutputSinceHeader) {
                    super.visitTaskOutput(this.getCurrentTask(), "\n");
                }
            } else {
                super.visitTaskOutput(this.getCurrentTask(), this.previousLine);
            }
            this.previousLine = null;
        }
    }

    @Override
    public void visitTaskHeader(TaskPath taskPath) {
        this.flushTaskOutput();
        this.hasOutputSinceHeader = false;
        super.visitTaskHeader(taskPath);
    }

    @Override
    public void visitTaskHeader(TaskPath taskPath, TaskOutcome taskOutcome) {
        this.flushTaskOutput();
        this.hasOutputSinceHeader = false;
        super.visitTaskHeader(taskPath, taskOutcome);
    }

    @Override
    public void visitTaskOutput(TaskPath taskPath, String line) {
        this.hasOutputSinceHeader = true;
        super.visitTaskOutput(taskPath, line);
    }

    @Override
    public void visitBuildResult(BuildOutcome buildOutcome) {
        this.flushTaskOutput();
        this.hasOutputSinceHeader = false;
        super.visitBuildResult(buildOutcome);
    }

    @Override
    public void visitBuildFailure() {
        this.flushTaskOutput();
        this.hasOutputSinceHeader = false;
        super.visitBuildFailure();
    }

    @Override
    public void visitContentLine(String line) {
        if (this.previousLine != null) {
            super.visitTaskOutput(this.getCurrentTask(), this.previousLine + "\n");
            this.previousLine = null;
        }
        if (this.getCurrentTask() != null) {
            this.previousLine = line;
        } else {
            super.visitContentLine(line);
        }
    }
}

