/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.ansi;

import net.rubygrapefruit.ansi.TextColor;

public class TextAttributes {
    private final boolean bold;
    private final TextColor color;
    private final TextColor background;
    public static final TextAttributes NORMAL = new TextAttributes(false, TextColor.DEFAULT, TextColor.DEFAULT);
    public static final TextAttributes BOLD = new TextAttributes(true, TextColor.DEFAULT, TextColor.DEFAULT);

    private TextAttributes(boolean bold, TextColor color, TextColor background) {
        this.bold = bold;
        this.color = color;
        this.background = background;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TextAttributes other = (TextAttributes)obj;
        return other.bold == this.bold && other.color.equals(this.color) && other.background.equals(this.background);
    }

    public int hashCode() {
        return this.color.hashCode() ^ this.background.hashCode() ^ (this.bold ? 31 : 1);
    }

    public boolean isBold() {
        return this.bold;
    }

    public TextColor getColor() {
        return this.color;
    }

    public TextColor getBackground() {
        return this.background;
    }

    public TextAttributes boldOn() {
        if (this.bold) {
            return this;
        }
        if (this.color.isDefault() && this.background.isDefault()) {
            return BOLD;
        }
        return new TextAttributes(true, this.color, this.background);
    }

    public TextAttributes boldOff() {
        if (!this.bold) {
            return this;
        }
        if (this.color.isDefault() && this.background.isDefault()) {
            return NORMAL;
        }
        return new TextAttributes(false, this.color, this.background);
    }

    public TextAttributes color(TextColor color) {
        if (this.color.equals(color)) {
            return this;
        }
        if (color.isDefault() && this.background.isDefault() && !this.bold) {
            return NORMAL;
        }
        return new TextAttributes(this.bold, color, this.background);
    }

    public TextAttributes background(TextColor background) {
        if (this.background.equals(background)) {
            return this;
        }
        if (this.color.isDefault() && background.isDefault() && !this.bold) {
            return NORMAL;
        }
        return new TextAttributes(this.bold, this.color, background);
    }
}

