/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.Task;

public final class TaskUtils {
    public static String temporaryDirectoryPath(Task task) {
        return "tmp/" + task.getName();
    }

    public static Action<Task> configureDependsOn(Object path, Object ... paths) {
        return new ConfigureDependsOnAction(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(path)).add(paths)).build());
    }

    public static Action<Task> configureGroup(String group) {
        return new ConfigureGroupAction(group);
    }

    private static final class ConfigureGroupAction
    implements Action<Task> {
        private final String group;

        public ConfigureGroupAction(String group) {
            this.group = Objects.requireNonNull(group);
        }

        public void execute(Task task) {
            task.setGroup(this.group);
        }

        public String toString() {
            return "TaskUtils.configureGroup(" + this.group + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigureGroupAction)) {
                return false;
            }
            ConfigureGroupAction other = (ConfigureGroupAction)o;
            String this$group = this.group;
            String other$group = other.group;
            return !(this$group == null ? other$group != null : !this$group.equals(other$group));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.group;
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            return result;
        }
    }

    private static final class ConfigureDependsOnAction
    implements Action<Task> {
        private final Iterable<Object> paths;

        public ConfigureDependsOnAction(Iterable<Object> paths) {
            this.paths = paths;
        }

        public void execute(Task task) {
            task.dependsOn(Iterables.toArray(this.paths, Object.class));
        }

        public String toString() {
            return "TaskUtils.configureDependsOn(" + this.paths + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigureDependsOnAction)) {
                return false;
            }
            ConfigureDependsOnAction other = (ConfigureDependsOnAction)o;
            Iterable<Object> this$paths = this.paths;
            Iterable<Object> other$paths = other.paths;
            return !(this$paths == null ? other$paths != null : !this$paths.equals(other$paths));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Iterable<Object> $paths = this.paths;
            result = result * 59 + ($paths == null ? 43 : $paths.hashCode());
            return result;
        }
    }
}

