/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import com.google.common.collect.ImmutableList;
import dev.nokee.utils.TransformerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public final class ProviderUtils {
    private ProviderUtils() {
    }

    public static <T> Provider<T> fixed(T value) {
        return Providers.of(Objects.requireNonNull(value));
    }

    public static <T> Provider<T> supplied(Callable<T> callable) {
        return new DefaultProvider(Objects.requireNonNull(callable));
    }

    public static <T> Provider<T> notDefined() {
        return Providers.notDefined();
    }

    @Nullable
    public static <T> Class<T> getType(Provider<T> self) {
        Objects.requireNonNull(self);
        if (self instanceof ProviderInternal) {
            return ((ProviderInternal)self).getType();
        }
        return null;
    }

    public static <OUT, IN> Transformer<List<OUT>, Iterable<IN>> flatMap(Transformer<Iterable<? extends OUT>, ? super IN> mapper) {
        return new GradleCollectionProviderFlatMapAdapter<OUT, IN>(mapper);
    }

    public static <OUT, IN> Transformer<List<OUT>, Iterable<IN>> map(Transformer<? extends OUT, ? super IN> mapper) {
        return new GradleCollectionProviderMapAdapter<OUT, IN>(mapper);
    }

    public static <T> Transformer<List<T>, Iterable<T>> filter(Spec<? super T> spec) {
        if (Specs.satisfyAll().equals(spec)) {
            return TransformerUtils.toListTransformer();
        }
        if (Specs.satisfyNone().equals(spec)) {
            return TransformerUtils.constant(Collections.emptyList());
        }
        return new GradleCollectionProviderFilterAdapter<T>(spec);
    }

    private static final class GradleCollectionProviderMapAdapter<OUT, IN>
    implements Transformer<List<OUT>, Iterable<IN>> {
        private final Transformer<? extends OUT, ? super IN> mapper;

        public GradleCollectionProviderMapAdapter(Transformer<? extends OUT, ? super IN> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
        }

        public List<OUT> transform(Iterable<IN> elements) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (IN element : elements) {
                result.add(this.mapper.transform(element));
            }
            return result.build();
        }

        public String toString() {
            return "ProviderUtils.map(" + this.mapper + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleCollectionProviderMapAdapter)) {
                return false;
            }
            GradleCollectionProviderMapAdapter other = (GradleCollectionProviderMapAdapter)o;
            Transformer<OUT, IN> this$mapper = this.mapper;
            Transformer<? extends OUT, ? super IN> other$mapper = other.mapper;
            return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Transformer<OUT, IN> $mapper = this.mapper;
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            return result;
        }
    }

    private static final class GradleCollectionProviderFlatMapAdapter<OUT, IN>
    implements Transformer<List<OUT>, Iterable<IN>> {
        private final Transformer<Iterable<? extends OUT>, ? super IN> mapper;

        public GradleCollectionProviderFlatMapAdapter(Transformer<Iterable<? extends OUT>, ? super IN> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
        }

        public List<OUT> transform(Iterable<IN> elements) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (IN element : elements) {
                result.addAll((Iterable)this.mapper.transform(element));
            }
            return result.build();
        }

        public String toString() {
            return "ProviderUtils.flatMap(" + this.mapper + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleCollectionProviderFlatMapAdapter)) {
                return false;
            }
            GradleCollectionProviderFlatMapAdapter other = (GradleCollectionProviderFlatMapAdapter)o;
            Transformer<Iterable<OUT>, IN> this$mapper = this.mapper;
            Transformer<Iterable<? extends OUT>, ? super IN> other$mapper = other.mapper;
            return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Transformer<Iterable<OUT>, IN> $mapper = this.mapper;
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            return result;
        }
    }

    private static final class GradleCollectionProviderFilterAdapter<T>
    implements Transformer<List<T>, Iterable<T>> {
        private final Spec<? super T> spec;

        public GradleCollectionProviderFilterAdapter(Spec<? super T> spec) {
            this.spec = Objects.requireNonNull(spec);
        }

        public List<T> transform(Iterable<T> elements) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (T element : elements) {
                if (!this.spec.isSatisfiedBy(element)) continue;
                result.add(element);
            }
            return result.build();
        }

        public String toString() {
            return "ProviderUtils.filter(" + this.spec + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleCollectionProviderFilterAdapter)) {
                return false;
            }
            GradleCollectionProviderFilterAdapter other = (GradleCollectionProviderFilterAdapter)o;
            Spec<T> this$spec = this.spec;
            Spec<? super T> other$spec = other.spec;
            return !(this$spec == null ? other$spec != null : !this$spec.equals(other$spec));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Spec<T> $spec = this.spec;
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            return result;
        }
    }
}

