/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import java.util.Objects;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static Action<Configuration> configureDescription(Supplier<String> description) {
        return new ConfigureDescriptionAction(description);
    }

    private static final class ConfigureDescriptionAction
    implements Action<Configuration> {
        private final Supplier<String> description;

        public ConfigureDescriptionAction(Supplier<String> description) {
            this.description = Objects.requireNonNull(description);
        }

        public void execute(Configuration configuration) {
            configuration.setDescription(this.description.get());
        }

        public String toString() {
            return "ConfigurationUtils.configureDescription(" + this.description + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigureDescriptionAction)) {
                return false;
            }
            ConfigureDescriptionAction other = (ConfigureDescriptionAction)o;
            Supplier<String> this$description = this.description;
            Supplier<String> other$description = other.description;
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<String> $description = this.description;
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }
    }
}

