/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import dev.nokee.ChainingAction;
import dev.nokee.utils.internal.CompositeAction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Action;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public final class ActionUtils {
    public static <T> Action<T> doNothing() {
        return DoNothingAction.INSTANCE;
    }

    @SafeVarargs
    public static <T> Action<? super T> composite(Action<? super T> ... actions) {
        return ActionUtils.composite(Arrays.stream(actions).filter(ActionUtils::doesSomething).collect(Collectors.toList()));
    }

    public static <T> Action<? super T> composite(Iterable<? extends Action<? super T>> actions) {
        List filtered = StreamSupport.stream(actions.spliterator(), false).filter(ActionUtils::doesSomething).collect(Collectors.toList());
        return ActionUtils.composite(filtered);
    }

    private static <T> Action<? super T> composite(List<? extends Action<? super T>> actions) {
        switch (actions.size()) {
            case 0: {
                return ActionUtils.doNothing();
            }
            case 1: {
                return actions.get(0);
            }
        }
        return new CompositeAction(actions);
    }

    public static boolean doesSomething(Action<?> action) {
        return action != DoNothingAction.INSTANCE;
    }

    public static <T> ChainingAction<? super T> chain(Action<? super T> action) {
        return ChainingAction.of(action);
    }

    public static <T> Action<T> onlyIf(Spec<? super T> spec, Action<? super T> action) {
        if (Specs.satisfyAll().equals(spec)) {
            Action<? super T> result = action;
            return result;
        }
        if (Specs.satisfyNone().equals(spec)) {
            return ActionUtils.doNothing();
        }
        return new SpecFilteringAction(spec, action);
    }

    public static <T, S> Action<T> onlyIf(Class<S> type, Action<? super S> action) {
        return new TypeFilteringAction(type, action);
    }

    public static <T, R> Action<T> map(Function<T, R> mapper, Action<? super R> action) {
        return new MappingAction(mapper, action);
    }

    private static final class MappingAction<T, R>
    implements Action<T> {
        private final Function<T, R> mapper;
        private final Action<? super R> action;

        private MappingAction(Function<T, R> mapper, Action<? super R> action) {
            this.mapper = Objects.requireNonNull(mapper);
            this.action = Objects.requireNonNull(action);
        }

        public void execute(T t) {
            this.action.execute(this.mapper.apply(t));
        }

        public String toString() {
            return "ActionUtils.map(" + this.mapper + ", " + this.action + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingAction)) {
                return false;
            }
            MappingAction other = (MappingAction)o;
            Function<T, R> this$mapper = this.mapper;
            Function<T, R> other$mapper = other.mapper;
            if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
                return false;
            }
            Action<R> this$action = this.action;
            Action<? super R> other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<T, R> $mapper = this.mapper;
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            Action<R> $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }

    private static final class TypeFilteringAction<T, S>
    implements Action<T> {
        private final Class<S> type;
        private final Action<? super S> action;

        public TypeFilteringAction(Class<S> type, Action<? super S> action) {
            this.type = Objects.requireNonNull(type);
            this.action = Objects.requireNonNull(action);
        }

        public void execute(T t) {
            if (this.type.isInstance(t)) {
                this.action.execute(this.type.cast(t));
            }
        }

        public String toString() {
            return "ActionUtils.onlyIf(" + this.type.getCanonicalName() + ", " + this.action + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeFilteringAction)) {
                return false;
            }
            TypeFilteringAction other = (TypeFilteringAction)o;
            Class<S> this$type = this.type;
            Class<S> other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Action<S> this$action = this.action;
            Action<? super S> other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<S> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Action<S> $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }

    private static final class SpecFilteringAction<T>
    implements Action<T> {
        private final Spec<? super T> spec;
        private final Action<? super T> action;

        private SpecFilteringAction(Spec<? super T> spec, Action<? super T> action) {
            this.spec = Objects.requireNonNull(spec);
            this.action = Objects.requireNonNull(action);
        }

        public void execute(T t) {
            if (this.spec.isSatisfiedBy(t)) {
                this.action.execute(t);
            }
        }

        public String toString() {
            return "ActionUtils.onlyIf(" + this.spec + ", " + this.action + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecFilteringAction)) {
                return false;
            }
            SpecFilteringAction other = (SpecFilteringAction)o;
            Spec<T> this$spec = this.spec;
            Spec<? super T> other$spec = other.spec;
            if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
                return false;
            }
            Action<T> this$action = this.action;
            Action<? super T> other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Spec<T> $spec = this.spec;
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            Action<T> $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }

    public static enum DoNothingAction implements ChainingAction<Object>,
    Action<Object>,
    Serializable
    {
        INSTANCE;


        public void execute(Object o) {
        }

        public String toString() {
            return "ActionUtils.doNothing()";
        }
    }
}

