/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec.internal;

import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolInvocation;
import dev.nokee.core.exec.CommandLineToolInvocationBuilder;
import dev.nokee.core.exec.CommandLineToolInvocationEnvironmentVariables;
import dev.nokee.core.exec.CommandLineToolInvocationErrorOutputRedirect;
import dev.nokee.core.exec.CommandLineToolInvocationStandardOutputRedirect;
import dev.nokee.core.exec.internal.CommandLineToolInvocationOutputRedirectInheritImpl;
import dev.nokee.core.exec.internal.CommandLineToolInvocationStandardOutputRedirectAppendToFileImpl;
import dev.nokee.core.exec.internal.DefaultCommandLineToolInvocation;
import java.io.File;

public class DefaultCommandLineToolInvocationBuilder
implements CommandLineToolInvocationBuilder {
    private final CommandLine commandLine;
    private File workingDirectory = null;
    private CommandLineToolInvocationStandardOutputRedirect standardOutputRedirect = new CommandLineToolInvocationOutputRedirectInheritImpl();
    private CommandLineToolInvocationErrorOutputRedirect errorOutputRedirect = new CommandLineToolInvocationOutputRedirectInheritImpl();
    private CommandLineToolInvocationEnvironmentVariables environmentVariables = CommandLineToolInvocationEnvironmentVariables.inherit();

    public DefaultCommandLineToolInvocationBuilder(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    @Override
    public CommandLineToolInvocationBuilder workingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    @Override
    public CommandLineToolInvocationBuilder withEnvironmentVariables(CommandLineToolInvocationEnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    @Override
    public CommandLineToolInvocationBuilder appendStandardStreamToFile(File file) {
        this.standardOutputRedirect = new CommandLineToolInvocationStandardOutputRedirectAppendToFileImpl(file);
        return this;
    }

    @Override
    public CommandLineToolInvocationBuilder redirectStandardOutput(CommandLineToolInvocationStandardOutputRedirect redirect) {
        this.standardOutputRedirect = redirect;
        return this;
    }

    @Override
    public CommandLineToolInvocationBuilder redirectErrorOutput(CommandLineToolInvocationErrorOutputRedirect redirect) {
        this.errorOutputRedirect = redirect;
        return this;
    }

    @Override
    public CommandLineToolInvocation build() {
        return new DefaultCommandLineToolInvocation(this.commandLine, this.standardOutputRedirect, this.errorOutputRedirect, this.workingDirectory, this.environmentVariables);
    }

    public CommandLineToolExecutionHandle buildAndSubmit(CommandLineToolExecutionEngine engine) {
        return engine.submit(this.build());
    }
}

