/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineToolLogContent;
import dev.nokee.core.exec.CommandLineToolLogContentEmptyImpl;
import dev.nokee.core.exec.CommandLineToolOutputParser;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.rubygrapefruit.ansi.AnsiParser;
import net.rubygrapefruit.ansi.console.AnsiConsole;
import net.rubygrapefruit.ansi.token.NewLine;
import net.rubygrapefruit.ansi.token.Text;
import org.apache.commons.lang3.StringUtils;

final class CommandLineToolLogContentImpl
implements CommandLineToolLogContent {
    private final String content;
    private final boolean definitelyNoAnsiChars;

    CommandLineToolLogContentImpl(String content, boolean definitelyNoAnsiChars) {
        this.content = content;
        this.definitelyNoAnsiChars = definitelyNoAnsiChars;
    }

    @Override
    public <T> T parse(CommandLineToolOutputParser<T> parser) {
        Objects.requireNonNull(parser, "Command line tool output parser cannot be null.");
        return parser.parse(this.content);
    }

    @Override
    public String getAsString() {
        return this.content;
    }

    @Override
    public CommandLineToolLogContent withNormalizedEndOfLine() {
        String newContent = CommandLineToolLogContentImpl.toLines(this.content).stream().map(CommandLineToolLogContentImpl::rtrim).collect(Collectors.joining("\n"));
        if (newContent.isEmpty()) {
            return CommandLineToolLogContentEmptyImpl.EMPTY_LOG_CONTENT;
        }
        return new CommandLineToolLogContentImpl(newContent, this.definitelyNoAnsiChars);
    }

    private static String rtrim(String str) {
        return str.replaceAll("\\s+$", "");
    }

    @Override
    public CommandLineToolLogContent drop(int i) {
        String newContent = this.content;
        while (i > 0 && !newContent.isEmpty()) {
            int indexOfEndOfLine = newContent.indexOf(10);
            if (indexOfEndOfLine == -1) {
                return CommandLineToolLogContentEmptyImpl.EMPTY_LOG_CONTENT;
            }
            newContent = newContent.substring(indexOfEndOfLine + 1);
            --i;
        }
        return new CommandLineToolLogContentImpl(newContent, this.definitelyNoAnsiChars);
    }

    @Override
    public CommandLineToolLogContent withAnsiControlCharactersInterpreted() {
        if (this.definitelyNoAnsiChars) {
            return this;
        }
        try {
            AnsiConsole console = CommandLineToolLogContentImpl.interpretAnsiChars(this.content);
            StringBuilder result = new StringBuilder();
            console.contents(token -> {
                if (token instanceof Text) {
                    result.append(((Text)token).getText());
                } else if (token instanceof NewLine) {
                    result.append("\n");
                }
            });
            return new CommandLineToolLogContentImpl(result.toString(), true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static AnsiConsole interpretAnsiChars(String content) throws IOException {
        AnsiConsole console = new AnsiConsole();
        AnsiParser parser = new AnsiParser();
        OutputStreamWriter writer = new OutputStreamWriter(parser.newParser("utf-8", console));
        writer.write(content);
        ((Writer)writer).flush();
        return console;
    }

    @Override
    public List<String> getLines() {
        return CommandLineToolLogContentImpl.toLines(this.content);
    }

    @Override
    public CommandLineToolLogContent visitEachLine(Consumer<CommandLineToolLogContent.LineDetails> visitor) {
        String currentLineSeparator;
        int indexOfEndOfLine;
        StringBuilder builder = new StringBuilder();
        int indexOfStartOfLine = 0;
        int n = 0;
        String previousLineSeparator = "";
        boolean lastLine = false;
        do {
            indexOfEndOfLine = this.content.indexOf(10, indexOfStartOfLine);
            currentLineSeparator = null;
            if (indexOfEndOfLine == -1) {
                indexOfEndOfLine = this.content.length();
                currentLineSeparator = "";
                lastLine = true;
            } else if (indexOfEndOfLine == 0) {
                currentLineSeparator = "\n";
            } else if (this.content.charAt(indexOfEndOfLine - 1) == '\r') {
                --indexOfEndOfLine;
                currentLineSeparator = "\r\n";
            } else {
                currentLineSeparator = "\n";
            }
            String line = this.content.substring(indexOfStartOfLine, indexOfEndOfLine);
            if (n == 0) {
                LineDetailsImpl details = new LineDetailsImpl(line);
                visitor.accept(details);
                n = details.n;
                if (n == 0) {
                    builder.append(previousLineSeparator).append(details.lineToAppend);
                    previousLineSeparator = currentLineSeparator;
                }
            }
            if (n <= 0) continue;
            --n;
        } while ((indexOfStartOfLine = indexOfEndOfLine + currentLineSeparator.length()) <= this.content.length() && !lastLine);
        String newContent = builder.toString();
        if (newContent.isEmpty()) {
            return CommandLineToolLogContentEmptyImpl.EMPTY_LOG_CONTENT;
        }
        return new CommandLineToolLogContentImpl(newContent, false);
    }

    private static List<String> toLines(String content) {
        return Arrays.stream(StringUtils.splitPreserveAllTokens(content, "\n", -1)).map(line -> {
            if (line.endsWith("\r")) {
                return line.substring(0, line.length() - 1);
            }
            return line;
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandLineToolLogContentImpl)) {
            return false;
        }
        CommandLineToolLogContentImpl other = (CommandLineToolLogContentImpl)o;
        String this$content = this.content;
        String other$content = other.content;
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    private static final class LineDetailsImpl
    implements CommandLineToolLogContent.LineDetails {
        private final String line;
        private String lineToAppend;
        private int n = 0;

        LineDetailsImpl(String line) {
            this.line = line;
            this.lineToAppend = line;
        }

        @Override
        public void dropLine() {
            this.n = 1;
        }

        @Override
        public void drop(int n) {
            this.n = n;
        }

        @Override
        public void replaceWith(String newLineContent) {
            if (newLineContent == null) {
                throw new IllegalArgumentException("Cannot replace line with a null value. If you need to erase the line from the resulting output, please use LineDetails#drop() API instead.");
            }
            this.lineToAppend = newLineContent;
        }

        @Override
        public String getLine() {
            return this.line;
        }
    }
}

