/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineToolLogContentEmptyImpl;
import dev.nokee.core.exec.CommandLineToolLogContentImpl;
import dev.nokee.core.exec.CommandLineToolOutputParser;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public interface CommandLineToolLogContent {
    public static CommandLineToolLogContent of(String content) {
        Objects.requireNonNull(content, "Cannot create log content from null.");
        if (content.isEmpty()) {
            return CommandLineToolLogContentEmptyImpl.EMPTY_LOG_CONTENT;
        }
        return new CommandLineToolLogContentImpl(content, false);
    }

    public static CommandLineToolLogContent empty() {
        return CommandLineToolLogContentEmptyImpl.EMPTY_LOG_CONTENT;
    }

    public <T> T parse(CommandLineToolOutputParser<T> var1);

    public String getAsString();

    public CommandLineToolLogContent withNormalizedEndOfLine();

    public CommandLineToolLogContent drop(int var1);

    public CommandLineToolLogContent withAnsiControlCharactersInterpreted();

    public List<String> getLines();

    public CommandLineToolLogContent visitEachLine(Consumer<LineDetails> var1);

    public static interface LineDetails {
        public void dropLine();

        public void drop(int var1);

        public void replaceWith(String var1);

        public String getLine();
    }
}

