/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.BeforeExecute;
import java.io.File;

public final class MissingSettingsFilePolicyProvider
extends AbstractGradleExecutionProvider<GradleExecutionContext.MissingSettingsFilePolicy>
implements BeforeExecute {
    public static MissingSettingsFilePolicyProvider createWhenMissing() {
        return MissingSettingsFilePolicyProvider.fixed(MissingSettingsFilePolicyProvider.class, GradleExecutionContext.MissingSettingsFilePolicy.CREATE_WHEN_MISSING);
    }

    public static MissingSettingsFilePolicyProvider ignoresWhenMissing() {
        return MissingSettingsFilePolicyProvider.fixed(MissingSettingsFilePolicyProvider.class, GradleExecutionContext.MissingSettingsFilePolicy.IGNORES_WHEN_MISSING);
    }

    public void validate() {
        switch ((GradleExecutionContext.MissingSettingsFilePolicy)this.get()) {
            case CREATE_WHEN_MISSING: 
            case IGNORES_WHEN_MISSING: {
                return;
            }
        }
        throw new IllegalArgumentException("Unaccounted for values");
    }

    @Override
    public void accept(GradleExecutionContext parameters) {
        if (((GradleExecutionContext.MissingSettingsFilePolicy)this.get()).equals((Object)GradleExecutionContext.MissingSettingsFilePolicy.CREATE_WHEN_MISSING)) {
            MissingSettingsFilePolicyProvider.ensureAvailable(parameters);
        }
    }

    private static void ensureAvailable(GradleExecutionContext parameters) {
        if (parameters.getWorkingDirectory().isPresent()) {
            File directory = (File)parameters.getWorkingDirectory().get();
            if (MissingSettingsFilePolicyProvider.hasSettingsFile(directory)) {
                return;
            }
            FileSystemUtils.createFile((File)FileSystemUtils.file((File)directory, (Object[])new Object[]{"settings.gradle"}));
        }
    }

    private static boolean hasSettingsFile(File directory) {
        if (directory.isDirectory()) {
            return FileSystemUtils.file((File)directory, (Object[])new Object[]{"settings.gradle"}).exists() || FileSystemUtils.file((File)directory, (Object[])new Object[]{"settings.gradle.kts"}).exists();
        }
        return false;
    }
}

