/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionJvmSystemPropertyProvider;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CharacterEncodingProvider
extends AbstractGradleExecutionProvider<Charset>
implements GradleExecutionJvmSystemPropertyProvider {
    public static CharacterEncodingProvider of(Charset characterEncoding) {
        return CharacterEncodingProvider.fixed(CharacterEncodingProvider.class, characterEncoding);
    }

    public static CharacterEncodingProvider defaultCharset() {
        return CharacterEncodingProvider.fixed(CharacterEncodingProvider.class, Charset.defaultCharset());
    }

    public static CharacterEncodingProvider unset() {
        return CharacterEncodingProvider.noValue(CharacterEncodingProvider.class);
    }

    @Override
    public Map<String, String> getAsJvmSystemProperties() {
        return this.map(CharacterEncodingProvider::asJvmSystemProperties).orElseGet(Collections::emptyMap);
    }

    private static Map<String, String> asJvmSystemProperties(Charset characterEncoding) {
        return Collections.singletonMap("file.encoding", characterEncoding.name());
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("-Dfile.encoding"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#withDefaultCharacterEncoding(Charset) instead of using the command line flags.");
        }
    }
}

