/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.ActionableTaskCount;
import dev.gradleplugins.runnerkit.BuildFailures;
import dev.gradleplugins.runnerkit.BuildOutcome;
import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.BuildTaskImpl;
import dev.gradleplugins.runnerkit.TaskOutcome;
import dev.gradleplugins.runnerkit.TaskOutcomeUtils;
import dev.gradleplugins.runnerkit.TaskPath;
import dev.nokee.core.exec.CommandLineToolLogContent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class BuildResultImpl
implements BuildResult {
    private final Map<TaskPath, BuildTask> executedTaskInOrder;
    private final ActionableTaskCount actionableTaskCount;
    private final BuildOutcome buildOutcome;
    private final BuildFailures failures;
    private final CommandLineToolLogContent output;

    public BuildResultImpl(Map<TaskPath, BuildTask> executedTaskInOrder, CommandLineToolLogContent output, ActionableTaskCount actionableTaskCount, BuildOutcome buildOutcome, BuildFailures failures) {
        this.executedTaskInOrder = executedTaskInOrder;
        this.output = output;
        this.actionableTaskCount = actionableTaskCount;
        this.buildOutcome = buildOutcome;
        this.failures = failures;
    }

    public BuildOutcome getOutcome() {
        return this.buildOutcome;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (BuildTask task : this.executedTaskInOrder.values()) {
            ((BuildTaskImpl)task).toString(result);
            result.append("\n");
        }
        result.append("\n");
        if (this.buildOutcome.equals((Object)BuildOutcome.FAILED)) {
            this.failures.toString(result);
            result.append("\n");
            result.append("\n");
        }
        result.append("BUILD ").append(this.getOutcome().name()).append("\n");
        this.actionableTaskCount.toString(result);
        return result.toString();
    }

    public String getOutput() {
        return this.output.getAsString();
    }

    public List<String> getExecutedTaskPaths() {
        return Collections.unmodifiableList(this.executedTaskInOrder.values().stream().map(BuildResultImpl::toPath).collect(Collectors.toList()));
    }

    public List<String> getSkippedTaskPaths() {
        return Collections.unmodifiableList(this.executedTaskInOrder.values().stream().filter(it -> TaskOutcomeUtils.isSkipped(it.getOutcome())).map(BuildResultImpl::toPath).collect(Collectors.toList()));
    }

    private static String toPath(BuildTask buildTask) {
        return buildTask.getPath();
    }

    public List<BuildTask> getTasks() {
        return Collections.unmodifiableList(new ArrayList<BuildTask>(this.executedTaskInOrder.values()));
    }

    public List<BuildTask> tasks(TaskOutcome outcome) {
        return Collections.unmodifiableList(this.executedTaskInOrder.values().stream().filter(it -> it.getOutcome().equals((Object)outcome)).collect(Collectors.toList()));
    }

    @Nullable
    public BuildTask task(String taskPath) {
        return this.executedTaskInOrder.get(TaskPath.of((String)taskPath));
    }

    public BuildResult withNormalizedTaskOutput(Predicate<TaskPath> predicate, UnaryOperator<String> outputNormalizer) {
        Map<TaskPath, BuildTask> tasks = Collections.unmodifiableMap(this.executedTaskInOrder.entrySet().stream().map(entry -> {
            if (predicate.test((TaskPath)entry.getKey())) {
                return new AbstractMap.SimpleEntry(entry.getKey(), new BuildTaskImpl((TaskPath)entry.getKey(), ((BuildTask)entry.getValue()).getOutcome(), (String)outputNormalizer.apply(((BuildTask)entry.getValue()).getOutput())));
            }
            return entry;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BuildResultImpl.throwingMerger(), LinkedHashMap::new)));
        return new BuildResultImpl(tasks, this.output, this.actionableTaskCount, this.buildOutcome, this.failures);
    }

    public BuildResult withoutBuildSrc() {
        Map<TaskPath, BuildTask> tasks = Collections.unmodifiableMap(this.executedTaskInOrder.entrySet().stream().filter(entry -> !((TaskPath)entry.getKey()).getProjectPath().equals(":buildSrc")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BuildResultImpl.throwingMerger(), LinkedHashMap::new)));
        return new BuildResultImpl(tasks, this.output, this.actionableTaskCount, this.buildOutcome, this.failures);
    }

    public BuildResult asRichOutputResult() {
        Map<TaskPath, BuildTask> tasks = Collections.unmodifiableMap(this.executedTaskInOrder.entrySet().stream().filter(it -> !((BuildTask)it.getValue()).getOutput().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BuildResultImpl.throwingMerger(), LinkedHashMap::new)));
        return new BuildResultImpl(tasks, this.output, this.actionableTaskCount, this.buildOutcome, this.failures);
    }

    public List<BuildResult.Failure> getFailures() {
        return this.failures.get();
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildResultImpl)) {
            return false;
        }
        BuildResultImpl other = (BuildResultImpl)o;
        Map<TaskPath, BuildTask> this$executedTaskInOrder = this.executedTaskInOrder;
        Map<TaskPath, BuildTask> other$executedTaskInOrder = other.executedTaskInOrder;
        if (this$executedTaskInOrder == null ? other$executedTaskInOrder != null : !((Object)this$executedTaskInOrder).equals(other$executedTaskInOrder)) {
            return false;
        }
        ActionableTaskCount this$actionableTaskCount = this.actionableTaskCount;
        ActionableTaskCount other$actionableTaskCount = other.actionableTaskCount;
        if (this$actionableTaskCount == null ? other$actionableTaskCount != null : !((Object)this$actionableTaskCount).equals(other$actionableTaskCount)) {
            return false;
        }
        BuildOutcome this$buildOutcome = this.buildOutcome;
        BuildOutcome other$buildOutcome = other.buildOutcome;
        if (this$buildOutcome == null ? other$buildOutcome != null : !this$buildOutcome.equals(other$buildOutcome)) {
            return false;
        }
        List<BuildResult.Failure> this$failures = this.getFailures();
        List<BuildResult.Failure> other$failures = other.getFailures();
        return !(this$failures == null ? other$failures != null : !((Object)this$failures).equals(other$failures));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TaskPath, BuildTask> $executedTaskInOrder = this.executedTaskInOrder;
        result = result * 59 + ($executedTaskInOrder == null ? 43 : ((Object)$executedTaskInOrder).hashCode());
        ActionableTaskCount $actionableTaskCount = this.actionableTaskCount;
        result = result * 59 + ($actionableTaskCount == null ? 43 : ((Object)$actionableTaskCount).hashCode());
        BuildOutcome $buildOutcome = this.buildOutcome;
        result = result * 59 + ($buildOutcome == null ? 43 : $buildOutcome.hashCode());
        List<BuildResult.Failure> $failures = this.getFailures();
        result = result * 59 + ($failures == null ? 43 : ((Object)$failures).hashCode());
        return result;
    }
}

