/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Properties;
import netflix.nebula.dependency.recommender.provider.FileBasedRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.FuzzyVersionResolver;
import org.gradle.api.Project;

public class PropertyFileRecommendationProvider
extends FileBasedRecommendationProvider {
    private Properties recommendations;
    private FuzzyVersionResolver fuzzyResolver = new FuzzyVersionResolver(){

        @Override
        protected Collection<String> propertyNames() {
            return PropertyFileRecommendationProvider.this.recommendations.stringPropertyNames();
        }

        @Override
        protected String propertyValue(String name) {
            return PropertyFileRecommendationProvider.this.recommendations.getProperty(name);
        }
    };

    public PropertyFileRecommendationProvider(Project project) {
        super(project);
    }

    @Override
    public String getVersion(String org, String name) throws Exception {
        if (this.recommendations == null) {
            this.recommendations = new Properties();
            this.recommendations.load(new ColonFilteringReader(new InputStreamReader(this.inputProvider.getInputStream())));
        }
        return this.fuzzyResolver.versionOf(org + "/" + name);
    }

    private class ColonFilteringReader
    extends Reader {
        Reader reader;

        public ColonFilteringReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int pos = this.reader.read(cbuf, off, len);
            for (int i = 0; i < cbuf.length; ++i) {
                if (cbuf[i] != ':') continue;
                cbuf[i] = 47;
            }
            return pos;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

