/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.netbeans.maven;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPropertyChange;
import org.mevenide.netbeans.api.customizer.changes.TextFieldPropertyChange;
import org.mevenide.netbeans.api.project.MavenProject;

public class InstallersPanel
extends JPanel {
    private MavenProject project;
    private String instId;
    private Set installers;
    private boolean initialized = false;
    private HashMap changes;
    private OriginChange ocDir;
    private OriginChange ocUrl;
    private JButton btnDir;
    private JButton btnRemove;
    private JButton btnUrl;
    private JSeparator jSeparator1;
    private JLabel lblDir;
    private JLabel lblID;
    private JLabel lblUrl;
    private JTextField txtDir;
    private JTextField txtID;
    private JTextField txtUrl;

    public InstallersPanel(MavenProject project, String id, Set installers) {
        this.project = project;
        this.instId = id;
        this.installers = installers;
        this.changes = new HashMap();
        this.initComponents();
    }

    private void initComponents() {
        this.lblID = new JLabel();
        this.txtID = new JTextField();
        this.btnRemove = new JButton();
        this.txtDir = new JTextField();
        this.txtUrl = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.lblDir = new JLabel();
        this.lblUrl = new JLabel();
        this.ocDir = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnDir = (JButton)this.ocDir.getComponent();
        this.ocUrl = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnUrl = (JButton)this.ocUrl.getComponent();
        this.setLayout(new GridBagLayout());
        this.lblID.setText("Zip URL Installer ID :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblID, gridBagConstraints);
        this.txtID.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.txtID, gridBagConstraints);
        this.btnRemove.setText("Remove Installer");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallersPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.lblDir.setText("Install Directory :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblDir, gridBagConstraints);
        this.lblUrl.setText("Download URL :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnUrl, gridBagConstraints);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.installers.remove(this.instId);
        this.ocDir.setAction(-2);
        this.ocUrl.setAction(-2);
        this.getParent().remove(this);
        this.getParent().validate();
        this.getParent().repaint();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        this.txtID.setText(this.instId);
        this.createChangeInstance("cargo.zipUrlInstaller." + this.instId + ".installUrl", this.txtUrl, this.ocUrl);
        this.createChangeInstance("cargo.zipUrlInstaller." + this.instId + ".installDir", this.txtDir, this.ocDir);
    }

    private TextFieldPropertyChange createChangeInstance(String key, JTextField field, OriginChange oc) {
        String value = this.project.getPropertyResolver().getValue(key);
        String defaultValue = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = defaultValue;
            location = -2;
        }
        TextFieldPropertyChange chng = new TextFieldPropertyChange(key, value, location, field, oc, defaultValue);
        this.changes.put(key, chng);
        return chng;
    }

    public List getChanges() {
        ArrayList<MavenPropertyChange> toReturn = new ArrayList<MavenPropertyChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenPropertyChange change = (MavenPropertyChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }
}

