/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.client.endpoints.functions;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.endpoints.functions.Url;
import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.HostKt;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.text.TextKt;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\r"}, d2={"substring", "", "value", "start", "", "stop", "reverse", "", "isValidHostLabel", "allowSubdomains", "uriEncode", "parseUrl", "Laws/smithy/kotlin/runtime/client/endpoints/functions/Url;", "smithy-client"})
@SourceDebugExtension(value={"SMAP\nFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Functions.kt\naws/smithy/kotlin/runtime/client/endpoints/functions/FunctionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1734#2,3:71\n*S KotlinDebug\n*F\n+ 1 Functions.kt\naws/smithy/kotlin/runtime/client/endpoints/functions/FunctionsKt\n*L\n29#1:71,3\n*E\n"})
public final class FunctionsKt {
    @InternalApi
    @Nullable
    public static final String substring(@Nullable String value, int start, int stop, boolean reverse) {
        String string;
        String string2 = value;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = start >= stop || stop > value.length() ? null : (reverse ? StringsKt.substring((String)value, (IntRange)RangesKt.until((int)(value.length() - stop), (int)(value.length() - start))) : StringsKt.substring((String)value, (IntRange)RangesKt.until((int)start, (int)stop)));
        } else {
            string = null;
        }
        return string;
    }

    @InternalApi
    public static final boolean isValidHostLabel(@Nullable String value, boolean allowSubdomains) {
        boolean bl;
        block7: {
            String string = value;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                if (!allowSubdomains) {
                    bl = aws.smithy.kotlin.runtime.net.TextKt.isValidHostname((String)value);
                } else {
                    char[] cArray = new char[]{'.'};
                    Iterable $this$all$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String p0 = (String)element$iv;
                            boolean bl3 = false;
                            if (aws.smithy.kotlin.runtime.net.TextKt.isValidHostname((String)p0)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @InternalApi
    @NotNull
    public static final String uriEncode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return PercentEncoding.Companion.getSmithyLabel().encode(value);
    }

    @InternalApi
    @Nullable
    public static final Url parseUrl(@Nullable String value) {
        if (value != null) {
            StringBuilder stringBuilder;
            String it = value;
            boolean bl = false;
            aws.smithy.kotlin.runtime.net.url.Url sdkUrl = null;
            try {
                sdkUrl = Url.Companion.parse$default((Url.Companion)aws.smithy.kotlin.runtime.net.url.Url.Companion, (String)value, null, (int)2, null);
            }
            catch (Exception e) {
                return null;
            }
            StringBuilder $this$parseUrl_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$parseUrl_u24lambda_u243_u24lambda_u242.append(HostKt.toUrlString((Host)sdkUrl.getHost()));
            if (sdkUrl.getPort() != sdkUrl.getScheme().getDefaultPort()) {
                $this$parseUrl_u24lambda_u243_u24lambda_u242.append("" + ':' + sdkUrl.getPort());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String authority = string;
            String sdkUrlPath = sdkUrl.getPath().toString();
            return new Url(sdkUrl.getScheme().getProtocolName(), authority, sdkUrlPath, TextKt.ensureSuffix((String)sdkUrlPath, (String)"/"), sdkUrl.getHost() instanceof Host.IpAddress);
        }
        return null;
    }
}

