/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.BigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.List;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegBigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Tag;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TagId;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.UInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/DecimalFraction;", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "value", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "<init>", "(Laws/smithy/kotlin/runtime/content/BigDecimal;)V", "getValue", "()Laws/smithy/kotlin/runtime/content/BigDecimal;", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
public final class DecimalFraction
implements Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal value;

    public DecimalFraction(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void encode(@NotNull SdkBufferedSink into) {
        Value exponent;
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        int cborExponent = -this.value.getExponent();
        Value value = exponent = cborExponent < 0 ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs(cborExponent)), null) : (Value)new UInt(ULong.constructor-impl((long)cborExponent), null);
        Value mantissa = this.value.getMantissa().compareTo(new BigInteger("-9223372036854775808")) > 0 && this.value.getMantissa().compareTo(new BigInteger("9223372036854775807")) < 0 ? (StringsKt.startsWith$default((String)this.value.getMantissa().toString(), (String)"-", (boolean)false, (int)2, null) ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs(this.value.getMantissa().longValue())), null) : (Value)new UInt(ULong.constructor-impl((long)this.value.getMantissa().longValue()), null)) : (StringsKt.startsWith$default((String)this.value.getMantissa().toString(), (String)"-", (boolean)false, (int)2, null) ? (Value)new NegBigNum(this.value.getMantissa()) : (Value)new BigNum(this.value.getMantissa()));
        Object[] objectArray = new Value[]{exponent, mantissa};
        new Tag(TagId.DECIMAL_FRACTION.getValue-s-VKNKU(), new List(CollectionsKt.listOf((Object[])objectArray)), null).encode(into);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/DecimalFraction$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/DecimalFraction;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "decode$serde_cbor", "serde-cbor"})
    @SourceDebugExtension(value={"SMAP\nTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tag.kt\naws/smithy/kotlin/runtime/serde/cbor/encoding/DecimalFraction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final DecimalFraction decode$serde_cbor(@NotNull SdkBufferedSource buffer) {
            int n;
            Value value;
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            java.util.List<Value> list = List.Companion.decode$serde_cbor(buffer).getValue();
            if (!(list.size() == 2)) {
                boolean $i$a$-check-DecimalFraction$Companion$decode$22 = false;
                String $i$a$-check-DecimalFraction$Companion$decode$22 = "Expected array of length 2 for decimal fraction, got " + list.size();
                throw new IllegalStateException($i$a$-check-DecimalFraction$Companion$decode$22.toString());
            }
            Value exponentValue = list.get(0);
            Value mantissaValue = list.get(1);
            Value value2 = mantissaValue;
            if (value2 instanceof UInt) {
                bigInteger = new BigInteger(Long.toUnsignedString(((UInt)mantissaValue).getValue-s-VKNKU()));
            } else if (value2 instanceof NegInt) {
                bigInteger = new BigInteger('-' + Long.toUnsignedString(((NegInt)mantissaValue).getValue-s-VKNKU()));
            } else {
                if (!(value2 instanceof Tag)) throw new DeserializationException("Expected UInt, NegInt, or Tag for CBOR decimal fraction mantissa, got " + mantissaValue);
                value = ((Tag)mantissaValue).getValue();
                if (value instanceof NegBigNum) {
                    bigInteger = ((NegBigNum)((Tag)mantissaValue).getValue()).getValue();
                } else {
                    if (!(value instanceof BigNum)) throw new DeserializationException("Expected BigNum or NegBigNum for CBOR tagged decimal fraction mantissa, got " + ULong.toString-impl((long)((Tag)mantissaValue).getId-s-VKNKU()));
                    bigInteger = ((BigNum)((Tag)mantissaValue).getValue()).getValue();
                }
            }
            BigInteger mantissa = bigInteger;
            value = exponentValue;
            if (value instanceof UInt) {
                n = (int)((UInt)exponentValue).getValue-s-VKNKU();
            } else {
                if (!(value instanceof NegInt)) throw new DeserializationException("Expected integer for CBOR decimal fraction exponent value, got " + exponentValue + '.');
                n = -((int)((NegInt)exponentValue).getValue-s-VKNKU());
            }
            int exponent = n;
            return new DecimalFraction(new BigDecimal(mantissa, -exponent));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

