/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.BigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Boolean;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.ByteString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.DecimalFraction;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float16;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float32;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float64;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Major;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MajorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Minor;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MinorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegBigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Null;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Tag;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TagId;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TextString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Timestamp;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.UInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u0002H\u0007\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00070\nH\u0082\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u0014\u001a\u0002H\u0007\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00070\nH\u0082\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/CborPrimitiveDeserializer;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkBufferedSource;)V", "deserializeNumber", "T", "", "cast", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Number;", "deserializeByte", "", "deserializeInt", "", "deserializeShort", "", "deserializeLong", "", "deserializeFloatingPoint", "deserializeFloat", "", "deserializeDouble", "", "deserializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeString", "", "deserializeBoolean", "", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeNull", "", "deserializeByteArray", "", "deserializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nCborDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborDeserializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborPrimitiveDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n62#1,11:259\n73#1,13:271\n62#1,11:284\n73#1,13:296\n62#1,11:309\n73#1,13:321\n62#1,11:334\n73#1,13:346\n94#1,13:359\n94#1,13:372\n1#2:258\n1#2:270\n1#2:295\n1#2:320\n1#2:345\n*S KotlinDebug\n*F\n+ 1 CborDeserializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborPrimitiveDeserializer\n*L\n88#1:259,11\n88#1:271,13\n89#1:284,11\n89#1:296,13\n90#1:309,11\n90#1:321,13\n91#1:334,11\n91#1:346,13\n109#1:359,13\n110#1:372,13\n88#1:270\n89#1:295\n90#1:320\n91#1:345\n*E\n"})
public final class CborPrimitiveDeserializer
implements PrimitiveDeserializer {
    @NotNull
    private final SdkBufferedSource buffer;

    public CborPrimitiveDeserializer(@NotNull SdkBufferedSource buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }

    private final /* synthetic */ <T extends Number> T deserializeNumber(Function1<? super Number, ? extends T> cast) {
        long l;
        long l2;
        boolean $i$f$deserializeNumber = false;
        Major major = MajorKt.peekMajor(this.buffer);
        switch (WhenMappings.$EnumSwitchMapping$0[major.ordinal()]) {
            case 1: {
                l2 = UInt.Companion.decode(this.buffer).getValue-s-VKNKU();
                break;
            }
            case 2: {
                l2 = NegInt.Companion.decode(this.buffer).getValue-s-VKNKU();
                break;
            }
            default: {
                throw new DeserializationException("Expected " + (Object)((Object)Major.U_INT) + " or " + (Object)((Object)Major.NEG_INT) + " for CBOR number, got " + (Object)((Object)major) + '.');
            }
        }
        long unsigned = l2;
        if (major == Major.NEG_INT) {
            if (!(Long.compareUnsigned(unsigned, ULong.constructor-impl((long)(ULong.constructor-impl((long)Long.MAX_VALUE) + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))))) <= 0)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$32 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$32 = "CBOR number " + ULong.toString-impl((long)unsigned) + " exceeds minimum value -9223372036854775808";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$32.toString());
            }
            l = -unsigned;
        } else {
            if (!(Long.compareUnsigned(unsigned, ULong.constructor-impl((long)Long.MAX_VALUE)) <= 0)) {
                boolean bl = false;
                String string = "CBOR number " + ULong.toString-impl((long)unsigned) + " exceeds maximum value 9223372036854775807";
                throw new IllegalStateException(string.toString());
            }
            l = unsigned;
        }
        long signed = l;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Number.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            if (!(-128L <= signed ? signed <= 127L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$42 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$42 = signed + " out of range for Byte";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$42.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            if (!(-32768L <= signed ? signed <= 32767L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$52 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$52 = signed + " out of range for Short";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$52.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (!(Integer.MIN_VALUE <= signed ? signed <= Integer.MAX_VALUE : false)) {
                boolean bl = false;
                String string = signed + " out of range for Int";
                throw new IllegalStateException(string.toString());
            }
        }
        return (T)((Number)cast.invoke((Object)signed));
    }

    public byte deserializeByte() {
        long l;
        long l2;
        CborPrimitiveDeserializer this_$iv = this;
        boolean $i$f$deserializeNumber = false;
        Major major$iv = MajorKt.peekMajor(this_$iv.buffer);
        switch (WhenMappings.$EnumSwitchMapping$0[major$iv.ordinal()]) {
            case 1: {
                l2 = UInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            case 2: {
                l2 = NegInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            default: {
                throw new DeserializationException("Expected " + (Object)((Object)Major.U_INT) + " or " + (Object)((Object)Major.NEG_INT) + " for CBOR number, got " + (Object)((Object)major$iv) + '.');
            }
        }
        long unsigned$iv = l2;
        if (major$iv == Major.NEG_INT) {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)(ULong.constructor-impl((long)Long.MAX_VALUE) + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))))) <= 0)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds minimum value -9223372036854775808";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22.toString());
            }
            l = -unsigned$iv;
        } else {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)Long.MAX_VALUE)) <= 0)) {
                boolean bl = false;
                String string = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds maximum value 9223372036854775807";
                throw new IllegalStateException(string.toString());
            }
            l = unsigned$iv;
        }
        long signed$iv = l;
        KClass kClass = Reflection.getOrCreateKotlinClass(Byte.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            if (!(-128L <= signed$iv ? signed$iv <= 127L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = signed$iv + " out of range for Byte";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            if (!(-32768L <= signed$iv ? signed$iv <= 32767L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = signed$iv + " out of range for Short";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (!(Integer.MIN_VALUE <= signed$iv ? signed$iv <= Integer.MAX_VALUE : false)) {
                boolean bl = false;
                String string = signed$iv + " out of range for Int";
                throw new IllegalStateException(string.toString());
            }
        }
        long it = signed$iv;
        boolean bl = false;
        return (byte)it;
    }

    public int deserializeInt() {
        long l;
        long l2;
        CborPrimitiveDeserializer this_$iv = this;
        boolean $i$f$deserializeNumber = false;
        Major major$iv = MajorKt.peekMajor(this_$iv.buffer);
        switch (WhenMappings.$EnumSwitchMapping$0[major$iv.ordinal()]) {
            case 1: {
                l2 = UInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            case 2: {
                l2 = NegInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            default: {
                throw new DeserializationException("Expected " + (Object)((Object)Major.U_INT) + " or " + (Object)((Object)Major.NEG_INT) + " for CBOR number, got " + (Object)((Object)major$iv) + '.');
            }
        }
        long unsigned$iv = l2;
        if (major$iv == Major.NEG_INT) {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)(ULong.constructor-impl((long)Long.MAX_VALUE) + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))))) <= 0)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds minimum value -9223372036854775808";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22.toString());
            }
            l = -unsigned$iv;
        } else {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)Long.MAX_VALUE)) <= 0)) {
                boolean bl = false;
                String string = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds maximum value 9223372036854775807";
                throw new IllegalStateException(string.toString());
            }
            l = unsigned$iv;
        }
        long signed$iv = l;
        KClass kClass = Reflection.getOrCreateKotlinClass(Integer.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            if (!(-128L <= signed$iv ? signed$iv <= 127L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = signed$iv + " out of range for Byte";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            if (!(-32768L <= signed$iv ? signed$iv <= 32767L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = signed$iv + " out of range for Short";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (!(Integer.MIN_VALUE <= signed$iv ? signed$iv <= Integer.MAX_VALUE : false)) {
                boolean bl = false;
                String string = signed$iv + " out of range for Int";
                throw new IllegalStateException(string.toString());
            }
        }
        long it = signed$iv;
        boolean bl = false;
        return (int)it;
    }

    public short deserializeShort() {
        long l;
        long l2;
        CborPrimitiveDeserializer this_$iv = this;
        boolean $i$f$deserializeNumber = false;
        Major major$iv = MajorKt.peekMajor(this_$iv.buffer);
        switch (WhenMappings.$EnumSwitchMapping$0[major$iv.ordinal()]) {
            case 1: {
                l2 = UInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            case 2: {
                l2 = NegInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            default: {
                throw new DeserializationException("Expected " + (Object)((Object)Major.U_INT) + " or " + (Object)((Object)Major.NEG_INT) + " for CBOR number, got " + (Object)((Object)major$iv) + '.');
            }
        }
        long unsigned$iv = l2;
        if (major$iv == Major.NEG_INT) {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)(ULong.constructor-impl((long)Long.MAX_VALUE) + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))))) <= 0)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds minimum value -9223372036854775808";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22.toString());
            }
            l = -unsigned$iv;
        } else {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)Long.MAX_VALUE)) <= 0)) {
                boolean bl = false;
                String string = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds maximum value 9223372036854775807";
                throw new IllegalStateException(string.toString());
            }
            l = unsigned$iv;
        }
        long signed$iv = l;
        KClass kClass = Reflection.getOrCreateKotlinClass(Short.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            if (!(-128L <= signed$iv ? signed$iv <= 127L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = signed$iv + " out of range for Byte";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            if (!(-32768L <= signed$iv ? signed$iv <= 32767L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = signed$iv + " out of range for Short";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (!(Integer.MIN_VALUE <= signed$iv ? signed$iv <= Integer.MAX_VALUE : false)) {
                boolean bl = false;
                String string = signed$iv + " out of range for Int";
                throw new IllegalStateException(string.toString());
            }
        }
        long it = signed$iv;
        boolean bl = false;
        return (short)it;
    }

    public long deserializeLong() {
        long l;
        long l2;
        CborPrimitiveDeserializer this_$iv = this;
        boolean $i$f$deserializeNumber = false;
        Major major$iv = MajorKt.peekMajor(this_$iv.buffer);
        switch (WhenMappings.$EnumSwitchMapping$0[major$iv.ordinal()]) {
            case 1: {
                l2 = UInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            case 2: {
                l2 = NegInt.Companion.decode(this_$iv.buffer).getValue-s-VKNKU();
                break;
            }
            default: {
                throw new DeserializationException("Expected " + (Object)((Object)Major.U_INT) + " or " + (Object)((Object)Major.NEG_INT) + " for CBOR number, got " + (Object)((Object)major$iv) + '.');
            }
        }
        long unsigned$iv = l2;
        if (major$iv == Major.NEG_INT) {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)(ULong.constructor-impl((long)Long.MAX_VALUE) + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))))) <= 0)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22 = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds minimum value -9223372036854775808";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$signed$1$iv22.toString());
            }
            l = -unsigned$iv;
        } else {
            if (!(Long.compareUnsigned(unsigned$iv, ULong.constructor-impl((long)Long.MAX_VALUE)) <= 0)) {
                boolean bl = false;
                String string = "CBOR number " + ULong.toString-impl((long)unsigned$iv) + " exceeds maximum value 9223372036854775807";
                throw new IllegalStateException(string.toString());
            }
            l = unsigned$iv;
        }
        long signed$iv = l;
        KClass kClass = Reflection.getOrCreateKotlinClass(Long.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            if (!(-128L <= signed$iv ? signed$iv <= 127L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22 = signed$iv + " out of range for Byte";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$1$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            if (!(-32768L <= signed$iv ? signed$iv <= 32767L : false)) {
                boolean $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = false;
                String $i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22 = signed$iv + " out of range for Short";
                throw new IllegalStateException($i$a$-check-CborPrimitiveDeserializer$deserializeNumber$2$iv22.toString());
            }
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            if (!(Integer.MIN_VALUE <= signed$iv ? signed$iv <= Integer.MAX_VALUE : false)) {
                boolean bl = false;
                String string = signed$iv + " out of range for Int";
                throw new IllegalStateException(string.toString());
            }
        }
        long it = signed$iv;
        boolean bl = false;
        return it;
    }

    private final /* synthetic */ <T extends Number> T deserializeFloatingPoint(Function1<? super Number, ? extends T> cast) {
        Number number;
        boolean $i$f$deserializeFloatingPoint = false;
        byte by = MinorKt.peekMinorByte(this.buffer);
        if (by == Minor.FLOAT16.getValue-w2LRezQ()) {
            number = Float.valueOf(Float16.Companion.decode(this.buffer).getValue());
        } else if (by == Minor.FLOAT32.getValue-w2LRezQ()) {
            number = Float.valueOf(Float32.Companion.decode(this.buffer).getValue());
        } else if (by == Minor.FLOAT64.getValue-w2LRezQ()) {
            number = Float64.Companion.decode(this.buffer).getValue();
        } else {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KClass kClass = Reflection.getOrCreateKotlinClass(Number.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                number = Float.valueOf(Float.intBitsToFloat((int)MinorKt.decodeArgument(this.buffer)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                number = Double.longBitsToDouble(MinorKt.decodeArgument(this.buffer));
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Unsupported floating point type: ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new DeserializationException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Number.class)).toString());
            }
        }
        Float number2 = number;
        return (T)((Number)cast.invoke((Object)number2));
    }

    public float deserializeFloat() {
        Number number;
        CborPrimitiveDeserializer this_$iv = this;
        boolean $i$f$deserializeFloatingPoint = false;
        byte by = MinorKt.peekMinorByte(this_$iv.buffer);
        if (by == Minor.FLOAT16.getValue-w2LRezQ()) {
            number = Float.valueOf(Float16.Companion.decode(this_$iv.buffer).getValue());
        } else if (by == Minor.FLOAT32.getValue-w2LRezQ()) {
            number = Float.valueOf(Float32.Companion.decode(this_$iv.buffer).getValue());
        } else if (by == Minor.FLOAT64.getValue-w2LRezQ()) {
            number = Float64.Companion.decode(this_$iv.buffer).getValue();
        } else {
            KClass kClass = Reflection.getOrCreateKotlinClass(Float.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                number = Float.valueOf(Float.intBitsToFloat((int)MinorKt.decodeArgument(this_$iv.buffer)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                number = Double.longBitsToDouble(MinorKt.decodeArgument(this_$iv.buffer));
            } else {
                throw new DeserializationException("Unsupported floating point type: " + Reflection.getOrCreateKotlinClass(Float.class));
            }
        }
        Float number$iv = number;
        Number it = number$iv;
        boolean bl = false;
        return it.floatValue();
    }

    public double deserializeDouble() {
        Number number;
        CborPrimitiveDeserializer this_$iv = this;
        boolean $i$f$deserializeFloatingPoint = false;
        byte by = MinorKt.peekMinorByte(this_$iv.buffer);
        if (by == Minor.FLOAT16.getValue-w2LRezQ()) {
            number = Float.valueOf(Float16.Companion.decode(this_$iv.buffer).getValue());
        } else if (by == Minor.FLOAT32.getValue-w2LRezQ()) {
            number = Float.valueOf(Float32.Companion.decode(this_$iv.buffer).getValue());
        } else if (by == Minor.FLOAT64.getValue-w2LRezQ()) {
            number = Float64.Companion.decode(this_$iv.buffer).getValue();
        } else {
            KClass kClass = Reflection.getOrCreateKotlinClass(Double.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                number = Float.valueOf(Float.intBitsToFloat((int)MinorKt.decodeArgument(this_$iv.buffer)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                number = Double.longBitsToDouble(MinorKt.decodeArgument(this_$iv.buffer));
            } else {
                throw new DeserializationException("Unsupported floating point type: " + Reflection.getOrCreateKotlinClass(Double.class));
            }
        }
        Float number$iv = number;
        Number it = number$iv;
        boolean bl = false;
        return it.doubleValue();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        BigInteger bigInteger;
        Value tag = Tag.Companion.decode(this.buffer).getValue();
        if (tag instanceof BigNum) {
            bigInteger = ((BigNum)tag).getValue();
        } else if (tag instanceof NegBigNum) {
            bigInteger = ((NegBigNum)tag).getValue();
        } else {
            throw new DeserializationException("Expected tag " + ULong.toString-impl((long)TagId.BIG_NUM.getValue-s-VKNKU()) + " or " + ULong.toString-impl((long)TagId.NEG_BIG_NUM.getValue-s-VKNKU()) + " for CBOR bignum, got " + tag);
        }
        return bigInteger;
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        Tag tag = Tag.Companion.decode(this.buffer);
        Value value = tag.getValue();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.cbor.encoding.DecimalFraction");
        return ((DecimalFraction)value).getValue();
    }

    @NotNull
    public String deserializeString() {
        return TextString.Companion.decode(this.buffer).getValue();
    }

    public boolean deserializeBoolean() {
        return Boolean.Companion.decode$serde_cbor(this.buffer).getValue();
    }

    @NotNull
    public Document deserializeDocument() {
        throw new DeserializationException("Document is not a supported CBOR type.");
    }

    @Nullable
    public Void deserializeNull() {
        Null.INSTANCE.decode$serde_cbor(this.buffer);
        return null;
    }

    @NotNull
    public byte[] deserializeByteArray() {
        return ByteString.Companion.decode(this.buffer).getValue();
    }

    @NotNull
    public Instant deserializeInstant(@NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Tag tag = Tag.Companion.decode(this.buffer);
        Value value = tag.getValue();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.cbor.encoding.Timestamp");
        return ((Timestamp)value).getValue();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Major.values().length];
            try {
                nArray[Major.U_INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Major.NEG_INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

