/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Boolean;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.ByteString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float16;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float32;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float64;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteBreak;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteList;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteMap;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.List;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Major;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MajorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Map;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Minor;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MinorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Null;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Tag;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TextString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.UInt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
public interface Value {
    @NotNull
    public static final Companion Companion = aws.smithy.kotlin.runtime.serde.cbor.encoding.Value$Companion.$$INSTANCE;

    public void encode(@NotNull SdkBufferedSink var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "serde-cbor"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Value decode(@NotNull SdkBufferedSource buffer) {
            Value value;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Major major = MajorKt.peekMajor(buffer);
            byte minor = MinorKt.peekMinorByte(buffer);
            switch (WhenMappings.$EnumSwitchMapping$0[major.ordinal()]) {
                case 1: {
                    value = UInt.Companion.decode(buffer);
                    break;
                }
                case 2: {
                    value = NegInt.Companion.decode(buffer);
                    break;
                }
                case 3: {
                    value = ByteString.Companion.decode(buffer);
                    break;
                }
                case 4: {
                    value = TextString.Companion.decode(buffer);
                    break;
                }
                case 5: {
                    return minor == Minor.INDEFINITE.getValue-w2LRezQ() ? (Value)IndefiniteList.Companion.decode$serde_cbor(buffer) : (Value)List.Companion.decode$serde_cbor(buffer);
                }
                case 6: {
                    if (minor == Minor.INDEFINITE.getValue-w2LRezQ()) {
                        value = IndefiniteMap.Companion.decode$serde_cbor(buffer);
                        break;
                    }
                    value = Map.Companion.decode$serde_cbor(buffer);
                    break;
                }
                case 7: {
                    value = Tag.Companion.decode(buffer);
                    break;
                }
                case 8: {
                    byte by = minor;
                    if (by == Minor.TRUE.getValue-w2LRezQ()) {
                        value = Boolean.Companion.decode$serde_cbor(buffer);
                        break;
                    }
                    if (by == Minor.FALSE.getValue-w2LRezQ()) {
                        value = Boolean.Companion.decode$serde_cbor(buffer);
                        break;
                    }
                    if (by == Minor.NULL.getValue-w2LRezQ()) {
                        value = Null.INSTANCE.decode$serde_cbor(buffer);
                        break;
                    }
                    if (by == Minor.UNDEFINED.getValue-w2LRezQ()) {
                        value = Null.INSTANCE.decode$serde_cbor(buffer);
                        break;
                    }
                    if (by == Minor.FLOAT16.getValue-w2LRezQ()) {
                        value = Float16.Companion.decode(buffer);
                        break;
                    }
                    if (by == Minor.FLOAT32.getValue-w2LRezQ()) {
                        value = Float32.Companion.decode(buffer);
                        break;
                    }
                    if (by == Minor.FLOAT64.getValue-w2LRezQ()) {
                        value = Float64.Companion.decode(buffer);
                        break;
                    }
                    if (by == Minor.INDEFINITE.getValue-w2LRezQ()) {
                        value = IndefiniteBreak.INSTANCE.decode$serde_cbor(buffer);
                        break;
                    }
                    throw new DeserializationException("Unexpected type 7 minor value " + UByte.toString-impl((byte)minor));
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return value;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Major.values().length];
                try {
                    nArray[Major.U_INT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.NEG_INT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.BYTE_STRING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.STRING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.LIST.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.MAP.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.TAG.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.TYPE_7.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

