/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Float16;", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "value", "", "<init>", "(F)V", "getValue", "()F", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
public final class Float16
implements Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float value;

    public Float16(float value) {
        this.value = value;
    }

    public final float getValue() {
        return this.value;
    }

    @NotNull
    public Void encode(@NotNull SdkBufferedSink into) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        throw new SerializationException("Encoding of CBOR 16-bit floats is not supported");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Float16$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Float16;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "serde-cbor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Float16 decode(@NotNull SdkBufferedSource buffer) {
            int n;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.readByte();
            byte[] bytes = buffer.readByteArray(2L);
            int float16Bits = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
            int sign = (float16Bits & 0x8000) << 16;
            int exponent = (float16Bits & 0x7C00) >> 10;
            int fraction = (float16Bits & 0x3FF) << 13;
            switch (exponent) {
                case 31: {
                    n = sign | 0x7F800000 | fraction;
                    break;
                }
                case 0: {
                    if (fraction == 0) {
                        n = sign;
                        break;
                    }
                    int subnormalFraction = fraction;
                    int e = 113;
                    while ((subnormalFraction & 0x800000) == 0) {
                        subnormalFraction <<= 1;
                        --e;
                    }
                    n = sign | e << 23 | subnormalFraction & 0x7FFFFF;
                    break;
                }
                default: {
                    n = sign | exponent + 112 << 23 | fraction;
                }
            }
            int float32 = n;
            return new Float16(Float.intBitsToFloat(float32));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

