/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float16;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float32;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float64;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Major;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MajorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Minor;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MinorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Tag;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.UInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.InstantKt;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Timestamp;", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "value", "Laws/smithy/kotlin/runtime/time/Instant;", "(Laws/smithy/kotlin/runtime/time/Instant;)V", "getValue", "()Laws/smithy/kotlin/runtime/time/Instant;", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
public final class Timestamp
implements Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant value;

    public Timestamp(@NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final Instant getValue() {
        return this.value;
    }

    @Override
    public void encode(@NotNull SdkBufferedSink into) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        new Tag(1L, new Float64((double)InstantKt.getEpochMilliseconds((Instant)this.value) / 1000.0), null).encode(into);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Timestamp$Companion;", "", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Timestamp;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "decode$serde_cbor", "serde-cbor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp decode$serde_cbor(@NotNull SdkBufferedSource buffer) {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Major major = MajorKt.peekMajor(buffer);
            byte minor = MinorKt.peekMinorByte(buffer);
            switch (WhenMappings.$EnumSwitchMapping$0[major.ordinal()]) {
                case 1: {
                    long timestamp = UInt.Companion.decode(buffer).getValue-s-VKNKU();
                    instant = Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)timestamp, (int)0, (int)2, null);
                    break;
                }
                case 2: {
                    long negativeTimestamp = NegInt.Companion.decode(buffer).getValue-s-VKNKU();
                    instant = Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)negativeTimestamp, (int)0, (int)2, null);
                    break;
                }
                case 3: {
                    double d;
                    byte by = minor;
                    if (by == Minor.FLOAT16.getValue-w2LRezQ()) {
                        d = Float16.Companion.decode(buffer).getValue();
                    } else if (by == Minor.FLOAT32.getValue-w2LRezQ()) {
                        d = Float32.Companion.decode(buffer).getValue();
                    } else if (by == Minor.FLOAT64.getValue-w2LRezQ()) {
                        d = Float64.Companion.decode(buffer).getValue();
                    } else {
                        throw new DeserializationException("Unexpected minor type " + UByte.toString-impl((byte)minor) + " for CBOR floating point timestamp, expected " + (Object)((Object)Minor.FLOAT16) + ", " + (Object)((Object)Minor.FLOAT32) + ", or " + (Object)((Object)Minor.FLOAT64) + '.');
                    }
                    double doubleTimestamp = d;
                    instant = InstantKt.fromEpochMilliseconds((Instant.Companion)Instant.Companion, (long)((long)(doubleTimestamp * (double)1000)));
                    break;
                }
                default: {
                    throw new DeserializationException("Unexpected major type " + (Object)((Object)major) + " for CBOR Timestamp. Expected " + (Object)((Object)Major.U_INT) + ", " + (Object)((Object)Major.NEG_INT) + ", or " + (Object)((Object)Major.TYPE_7) + '.');
                }
            }
            Instant instant2 = instant;
            return new Timestamp(instant2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Major.values().length];
                try {
                    nArray[Major.U_INT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.NEG_INT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Major.TYPE_7.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

