/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Major;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Minor;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Float32;", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "value", "", "(F)V", "getValue", "()F", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nNumbers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Numbers.kt\naws/smithy/kotlin/runtime/serde/cbor/encoding/Float32\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1549#2:135\n1620#2,3:136\n*S KotlinDebug\n*F\n+ 1 Numbers.kt\naws/smithy/kotlin/runtime/serde/cbor/encoding/Float32\n*L\n94#1:135\n94#1:136,3\n*E\n"})
public final class Float32
implements Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float value;

    public Float32(float value) {
        this.value = value;
    }

    public final float getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encode(@NotNull SdkBufferedSink into) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        int bits = Float.floatToRawIntBits(this.value);
        Iterable $this$map$iv = (Iterable)RangesKt.step((IntProgression)RangesKt.downTo((int)24, (int)0), (int)8);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void shiftAmount;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)(bits >> shiftAmount & 0xFF));
        }
        byte[] bytes = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
        into.writeByte(CborUtilsKt.encodeMajorMinor(Major.TYPE_7, Minor.FLOAT32));
        SdkBufferedSink.DefaultImpls.write$default((SdkBufferedSink)into, (byte[])bytes, (int)0, (int)0, (int)6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Float32$Companion;", "", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Float32;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "serde-cbor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Float32 decode(@NotNull SdkBufferedSource buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.readByte();
            byte[] bytes = buffer.readByteArray(4L);
            return new Float32(Float.intBitsToFloat((int)CborUtilsKt.toULong(bytes)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

