/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.cbor.CborPrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteBreak;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u0096\u0001J\t\u0010 \u001a\u00020!H\u0096\u0001J\u0011\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0096\u0001J\t\u0010&\u001a\u00020'H\u0096\u0001J\t\u0010(\u001a\u00020)H\u0096\u0001J\u000b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0001J\t\u0010,\u001a\u00020-H\u0096\u0001J\t\u0010.\u001a\u00020/H\u0096\u0001J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u00020\u0017H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00062"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/CborElementIterator;", "Laws/smithy/kotlin/runtime/serde/Deserializer$ElementIterator;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "expectedLength", "Lkotlin/ULong;", "(Laws/smithy/kotlin/runtime/io/SdkBufferedSource;Lkotlin/ULong;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "currentLength", "getCurrentLength-s-VKNKU", "()J", "setCurrentLength-VKZWuLQ", "(J)V", "J", "getExpectedLength-6VbMDqA", "()Lkotlin/ULong;", "deserializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBoolean", "", "deserializeByte", "", "deserializeByteArray", "", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeDouble", "", "deserializeFloat", "", "deserializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "deserializeInt", "", "deserializeLong", "", "deserializeNull", "", "deserializeShort", "", "deserializeString", "", "hasNextElement", "nextHasValue", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nCborDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborDeserializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborElementIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
final class CborElementIterator
implements Deserializer.ElementIterator,
PrimitiveDeserializer {
    @NotNull
    private final SdkBufferedSource buffer;
    @Nullable
    private final ULong expectedLength;
    private final /* synthetic */ CborPrimitiveDeserializer $$delegate_0;
    private long currentLength;

    private CborElementIterator(SdkBufferedSource buffer, ULong expectedLength) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.expectedLength = expectedLength;
        this.$$delegate_0 = new CborPrimitiveDeserializer(buffer);
    }

    public /* synthetic */ CborElementIterator(SdkBufferedSource sdkBufferedSource, ULong uLong, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uLong = null;
        }
        this(sdkBufferedSource, uLong, null);
    }

    @NotNull
    public final SdkBufferedSource getBuffer() {
        return this.buffer;
    }

    @Nullable
    public final ULong getExpectedLength-6VbMDqA() {
        return this.expectedLength;
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        return this.$$delegate_0.deserializeBigDecimal();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        return this.$$delegate_0.deserializeBigInteger();
    }

    public boolean deserializeBoolean() {
        return this.$$delegate_0.deserializeBoolean();
    }

    public byte deserializeByte() {
        return this.$$delegate_0.deserializeByte();
    }

    @NotNull
    public byte[] deserializeByteArray() {
        return this.$$delegate_0.deserializeByteArray();
    }

    @NotNull
    public Document deserializeDocument() {
        return this.$$delegate_0.deserializeDocument();
    }

    public double deserializeDouble() {
        return this.$$delegate_0.deserializeDouble();
    }

    public float deserializeFloat() {
        return this.$$delegate_0.deserializeFloat();
    }

    @NotNull
    public Instant deserializeInstant(@NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return this.$$delegate_0.deserializeInstant(format);
    }

    public int deserializeInt() {
        return this.$$delegate_0.deserializeInt();
    }

    public long deserializeLong() {
        return this.$$delegate_0.deserializeLong();
    }

    @Nullable
    public Void deserializeNull() {
        return this.$$delegate_0.deserializeNull();
    }

    public short deserializeShort() {
        return this.$$delegate_0.deserializeShort();
    }

    @NotNull
    public String deserializeString() {
        return this.$$delegate_0.deserializeString();
    }

    public final long getCurrentLength-s-VKNKU() {
        return this.currentLength;
    }

    public final void setCurrentLength-VKZWuLQ(long l) {
        this.currentLength = l;
    }

    public boolean hasNextElement() {
        boolean bl;
        if (this.expectedLength != null) {
            if (!ULong.equals-impl((long)this.currentLength, (Object)this.expectedLength)) {
                if (!(!this.buffer.exhausted())) {
                    boolean $i$a$-check-CborElementIterator$hasNextElement$32 = false;
                    String $i$a$-check-CborElementIterator$hasNextElement$32 = "Buffer is unexpectedly exhausted, read " + ULong.toString-impl((long)this.currentLength) + " elements, expected " + this.expectedLength + '.';
                    throw new IllegalStateException($i$a$-check-CborElementIterator$hasNextElement$32.toString());
                }
                this.currentLength = ULong.constructor-impl((long)(this.currentLength + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL))));
                return true;
            }
            return false;
        }
        if (CborUtilsKt.getNextValueIsIndefiniteBreak(this.buffer)) {
            IndefiniteBreak.INSTANCE.decode$serde_cbor(this.buffer);
            bl = false;
        } else {
            if (!(!this.buffer.exhausted())) {
                boolean bl2 = false;
                String string = "Buffer is unexpectedly exhausted";
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        return bl;
    }

    public boolean nextHasValue() {
        return !CborUtilsKt.getNextValueIsNull(this.buffer);
    }

    public /* synthetic */ CborElementIterator(SdkBufferedSource buffer, ULong expectedLength, DefaultConstructorMarker $constructor_marker) {
        this(buffer, expectedLength);
    }
}

