/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/io/RandomAccessFileSource;", "Lokio/Source;", "fileObject", "Ljava/io/File;", "start", "", "endInclusive", "timeout", "Lokio/Timeout;", "(Ljava/io/File;JJLokio/Timeout;)V", "file", "Ljava/io/RandomAccessFile;", "getFile", "()Ljava/io/RandomAccessFile;", "file$delegate", "Lkotlin/Lazy;", "position", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "toString", "", "io"})
@SourceDebugExtension(value={"SMAP\nRandomAccessFileSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomAccessFileSource.kt\naws/smithy/kotlin/runtime/io/RandomAccessFileSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class RandomAccessFileSource
implements Source {
    @NotNull
    private final File fileObject;
    private final long endInclusive;
    @NotNull
    private final Timeout timeout;
    @NotNull
    private final Lazy file$delegate;
    private long position;

    public RandomAccessFileSource(@NotNull File fileObject, long start, long endInclusive, @NotNull Timeout timeout) {
        Intrinsics.checkNotNullParameter((Object)fileObject, (String)"fileObject");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.fileObject = fileObject;
        this.endInclusive = endInclusive;
        this.timeout = timeout;
        this.file$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RandomAccessFile>(this, start){
            final /* synthetic */ RandomAccessFileSource this$0;
            final /* synthetic */ long $start;
            {
                this.this$0 = $receiver;
                this.$start = $start;
                super(0);
            }

            @NotNull
            public final RandomAccessFile invoke() {
                boolean bl = RandomAccessFileSource.access$getFileObject$p(this.this$0).exists();
                RandomAccessFileSource randomAccessFileSource = this.this$0;
                if (!bl) {
                    boolean $i$a$-require-RandomAccessFileSource$file$2$52 = false;
                    String $i$a$-require-RandomAccessFileSource$file$2$52 = "cannot create SdkSource, file does not exist: " + randomAccessFileSource;
                    throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$52.toString());
                }
                bl = RandomAccessFileSource.access$getFileObject$p(this.this$0).isFile();
                randomAccessFileSource = this.this$0;
                if (!bl) {
                    boolean $i$a$-require-RandomAccessFileSource$file$2$62 = false;
                    String $i$a$-require-RandomAccessFileSource$file$2$62 = "cannot create a SdkSource from a directory: " + randomAccessFileSource;
                    throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$62.toString());
                }
                bl = this.$start >= 0L;
                long l = this.$start;
                if (!bl) {
                    boolean $i$a$-require-RandomAccessFileSource$file$2$72 = false;
                    String $i$a$-require-RandomAccessFileSource$file$2$72 = "start position should be >= 0, found " + l;
                    throw new IllegalArgumentException($i$a$-require-RandomAccessFileSource$file$2$72.toString());
                }
                bl = RandomAccessFileSource.access$getEndInclusive$p(this.this$0) >= 0L && RandomAccessFileSource.access$getEndInclusive$p(this.this$0) <= RandomAccessFileSource.access$getFileObject$p(this.this$0).length() - 1L;
                RandomAccessFileSource randomAccessFileSource2 = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "endInclusive should be less than or equal to the length of the file, was " + RandomAccessFileSource.access$getEndInclusive$p(randomAccessFileSource2);
                    throw new IllegalArgumentException(string.toString());
                }
                RandomAccessFile randomAccessFile = new RandomAccessFile(RandomAccessFileSource.access$getFileObject$p(this.this$0), "r");
                long l2 = this.$start;
                RandomAccessFile it = randomAccessFile;
                boolean bl3 = false;
                if (l2 > 0L) {
                    it.seek(l2);
                }
                return randomAccessFile;
            }
        }));
        this.position = start;
    }

    public /* synthetic */ RandomAccessFileSource(File file2, long l, long l2, Timeout timeout, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeout = Timeout.NONE;
        }
        this(file2, l, l2, timeout);
    }

    private final RandomAccessFile getFile() {
        Lazy lazy = this.file$delegate;
        return (RandomAccessFile)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return "RandomAccessFileSource(" + this.fileObject + ')';
    }

    @NotNull
    public Timeout timeout() {
        return this.timeout;
    }

    public long read(@NotNull Buffer sink, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        FileChannel channel = this.getFile().getChannel();
        if (!channel.isOpen()) {
            boolean bl = false;
            String string = "channel is closed";
            throw new IllegalStateException(string.toString());
        }
        if (this.position > this.endInclusive) {
            return -1L;
        }
        long bytesRequested = Math.min(byteCount, this.endInclusive - this.position + 1L);
        long rc = channel.transferTo(this.position, bytesRequested, (WritableByteChannel)sink);
        this.position += rc;
        return rc;
    }

    public void close() {
        this.getFile().close();
    }

    public static final /* synthetic */ File access$getFileObject$p(RandomAccessFileSource $this) {
        return $this.fileObject;
    }

    public static final /* synthetic */ long access$getEndInclusive$p(RandomAccessFileSource $this) {
        return $this.endInclusive;
    }
}

