/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.operation;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.SdkClientOption;
import aws.smithy.kotlin.runtime.collections.AttributeKey;
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize;
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer;
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext;
import aws.smithy.kotlin.runtime.http.operation.HttpSerdeKt;
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize;
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer;
import aws.smithy.kotlin.runtime.http.operation.OperationTypeInfo;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation;
import aws.smithy.kotlin.runtime.http.operation.SdkOperationExecution;
import aws.smithy.kotlin.runtime.http.operation.SdkOperationTelemetry;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u001f\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\fR\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\fR\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R@\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00128\u0006@FX\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R*\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R@\u0010$\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010#2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010#8\u0006@FX\u0087\u000e\u00a2\u0006\u0018\n\u0004\b$\u0010%\u0012\u0004\b*\u0010\u001b\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R*\u0010,\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R#\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001028\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R$\u0010=\u001a\u0004\u0018\u00010<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR$\u0010C\u001a\u0004\u0018\u00010<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010>\u001a\u0004\bD\u0010@\"\u0004\bE\u0010BR$\u0010F\u001a\u0004\u0018\u00010<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010>\u001a\u0004\bG\u0010@\"\u0004\bH\u0010B\u00a8\u0006I"}, d2={"Laws/smithy/kotlin/runtime/http/operation/SdkHttpOperationBuilder;", "I", "O", "", "Lkotlin/reflect/KClass;", "inputType", "outputType", "<init>", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;)V", "Laws/smithy/kotlin/runtime/http/operation/SdkHttpOperation;", "build", "()Laws/smithy/kotlin/runtime/http/operation/SdkHttpOperation;", "Lkotlin/reflect/KClass;", "Laws/smithy/kotlin/runtime/http/operation/SdkOperationTelemetry;", "telemetry", "Laws/smithy/kotlin/runtime/http/operation/SdkOperationTelemetry;", "getTelemetry", "()Laws/smithy/kotlin/runtime/http/operation/SdkOperationTelemetry;", "Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "value", "serializer", "Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "getSerializer", "()Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "setSerializer", "(Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;)V", "getSerializer$annotations", "()V", "Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;", "serializeWith", "Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;", "getSerializeWith", "()Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;", "setSerializeWith", "(Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;)V", "Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;", "deserializer", "Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;", "getDeserializer", "()Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;", "setDeserializer", "(Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;)V", "getDeserializer$annotations", "Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;", "deserializeWith", "Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;", "getDeserializeWith", "()Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;", "setDeserializeWith", "(Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;)V", "Laws/smithy/kotlin/runtime/http/operation/SdkOperationExecution;", "execution", "Laws/smithy/kotlin/runtime/http/operation/SdkOperationExecution;", "getExecution", "()Laws/smithy/kotlin/runtime/http/operation/SdkOperationExecution;", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "getContext", "()Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "", "operationName", "Ljava/lang/String;", "getOperationName", "()Ljava/lang/String;", "setOperationName", "(Ljava/lang/String;)V", "serviceName", "getServiceName", "setServiceName", "hostPrefix", "getHostPrefix", "setHostPrefix", "http-client"})
@SourceDebugExtension(value={"SMAP\nSdkHttpOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkHttpOperation.kt\naws/smithy/kotlin/runtime/http/operation/SdkHttpOperationBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class SdkHttpOperationBuilder<I, O> {
    @NotNull
    private final KClass<?> inputType;
    @NotNull
    private final KClass<?> outputType;
    @NotNull
    private final SdkOperationTelemetry telemetry;
    @Nullable
    private HttpSerialize<I> serializer;
    @Nullable
    private HttpSerializer<I> serializeWith;
    @Nullable
    private HttpDeserialize<O> deserializer;
    @Nullable
    private HttpDeserializer<O> deserializeWith;
    @NotNull
    private final SdkOperationExecution<I, O> execution;
    @NotNull
    private final ExecutionContext context;
    @Nullable
    private String operationName;
    @Nullable
    private String serviceName;
    @Nullable
    private String hostPrefix;

    public SdkHttpOperationBuilder(@NotNull KClass<?> inputType, @NotNull KClass<?> outputType) {
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.inputType = inputType;
        this.outputType = outputType;
        this.telemetry = new SdkOperationTelemetry();
        this.execution = new SdkOperationExecution();
        this.context = new ExecutionContext();
    }

    @NotNull
    public final SdkOperationTelemetry getTelemetry() {
        return this.telemetry;
    }

    @Nullable
    public final HttpSerialize<I> getSerializer() {
        return this.serializer;
    }

    public final void setSerializer(@Nullable HttpSerialize<I> value) {
        this.serializer = value;
        HttpSerialize<I> httpSerialize = value;
        this.serializeWith = httpSerialize != null ? HttpSerdeKt.intoSerializer(httpSerialize) : null;
    }

    @Deprecated(message="use serializeWith")
    public static /* synthetic */ void getSerializer$annotations() {
    }

    @Nullable
    public final HttpSerializer<I> getSerializeWith() {
        return this.serializeWith;
    }

    public final void setSerializeWith(@Nullable HttpSerializer<I> httpSerializer) {
        this.serializeWith = httpSerializer;
    }

    @Nullable
    public final HttpDeserialize<O> getDeserializer() {
        return this.deserializer;
    }

    public final void setDeserializer(@Nullable HttpDeserialize<O> value) {
        this.deserializer = value;
        HttpDeserialize<O> httpDeserialize = value;
        this.deserializeWith = httpDeserialize != null ? HttpSerdeKt.intoDeserializer(httpDeserialize) : null;
    }

    @Deprecated(message="use deserializeWith")
    public static /* synthetic */ void getDeserializer$annotations() {
    }

    @Nullable
    public final HttpDeserializer<O> getDeserializeWith() {
        return this.deserializeWith;
    }

    public final void setDeserializeWith(@Nullable HttpDeserializer<O> httpDeserializer) {
        this.deserializeWith = httpDeserializer;
    }

    @NotNull
    public final SdkOperationExecution<I, O> getExecution() {
        return this.execution;
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    @Nullable
    public final String getOperationName() {
        return this.operationName;
    }

    public final void setOperationName(@Nullable String string) {
        this.operationName = string;
    }

    @Nullable
    public final String getServiceName() {
        return this.serviceName;
    }

    public final void setServiceName(@Nullable String string) {
        this.serviceName = string;
    }

    @Nullable
    public final String getHostPrefix() {
        return this.hostPrefix;
    }

    public final void setHostPrefix(@Nullable String string) {
        this.hostPrefix = string;
    }

    @NotNull
    public final SdkHttpOperation<I, O> build() {
        HttpSerializer<I> httpSerializer = this.serializeWith;
        if (httpSerializer == null) {
            boolean $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opSerializer$22 = false;
            String $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opSerializer$22 = "SdkHttpOperation.serializeWith must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-SdkHttpOperationBuilder$build$opSerializer$22.toString());
        }
        HttpSerializer<I> opSerializer = httpSerializer;
        HttpDeserializer<O> httpDeserializer = this.deserializeWith;
        if (httpDeserializer == null) {
            boolean $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opDeserializer$22 = false;
            String $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opDeserializer$22 = "SdkHttpOperation.deserializeWith must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-SdkHttpOperationBuilder$build$opDeserializer$22.toString());
        }
        HttpDeserializer<O> opDeserializer = httpDeserializer;
        if (this.operationName == null) {
            boolean $i$a$-requireNotNull-SdkHttpOperationBuilder$build$32 = false;
            String $i$a$-requireNotNull-SdkHttpOperationBuilder$build$32 = "operationName is a required HTTP execution attribute";
            throw new IllegalArgumentException($i$a$-requireNotNull-SdkHttpOperationBuilder$build$32.toString());
        }
        if (this.serviceName == null) {
            boolean bl = false;
            String string = "serviceName is a required HTTP execution attribute";
            throw new IllegalArgumentException(string.toString());
        }
        AttributeKey attributeKey = SdkClientOption.INSTANCE.getOperationName();
        String string = this.operationName;
        Intrinsics.checkNotNull((Object)string);
        this.context.set(attributeKey, (Object)string);
        AttributeKey attributeKey2 = SdkClientOption.INSTANCE.getServiceName();
        String string2 = this.serviceName;
        Intrinsics.checkNotNull((Object)string2);
        this.context.set(attributeKey2, (Object)string2);
        String string3 = this.hostPrefix;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            this.context.set(HttpOperationContext.INSTANCE.getHostPrefix(), (Object)it);
        }
        OperationTypeInfo typeInfo = new OperationTypeInfo(this.inputType, this.outputType);
        return new SdkHttpOperation<I, O>(this.execution, this.context, opSerializer, opDeserializer, typeInfo, this.telemetry);
    }
}

