/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetric;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetricsUtilsKt;
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HashFunctionKt;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.http.request.HttpRequestKt;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a+\u0010\u0006\u001a\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\"&\u0010\u000b\u001a\u0004\u0018\u00010\b*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00020\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;", "", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "context", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "checksumAlgorithm", "calculateAwsChunkedStreamingChecksum", "(Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;Laws/smithy/kotlin/runtime/hashing/HashFunction;)Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "", "getDefaultChecksumAlgorithmName", "(Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;)Ljava/lang/String;", "defaultChecksumAlgorithmName", "http-client"})
public final class ChecksumInterceptorUtilsKt {
    @NotNull
    public static final HttpRequest calculateAwsChunkedStreamingChecksum(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull HashFunction checksumAlgorithm) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)checksumAlgorithm, (String)"checksumAlgorithm");
        HttpRequestBuilder request = HttpRequestKt.toBuilder((HttpRequest)((HttpRequest)context.getProtocolRequest()));
        CompletableDeferred deferredChecksum = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)context.getExecutionContext().getCoroutineContext()));
        String checksumHeader = HashFunctionKt.resolveChecksumAlgorithmHeaderName((HashFunction)checksumAlgorithm);
        request.setBody(HttpBodyKt.toCompletingBody((HttpBody)HttpBodyKt.toHashingBody((HttpBody)request.getBody(), (HashFunction)checksumAlgorithm, (Long)request.getBody().getContentLength()), (CompletableDeferred)deferredChecksum));
        request.getHeaders().append("x-amz-trailer", (Object)checksumHeader);
        request.getTrailingHeaders().append(checksumHeader, (Object)deferredChecksum);
        BusinessMetricsUtilsKt.emitBusinessMetric((ExecutionContext)context.getExecutionContext(), (BusinessMetric)HashFunctionKt.toBusinessMetric((HashFunction)checksumAlgorithm));
        return request.build();
    }

    @Nullable
    public static final String getDefaultChecksumAlgorithmName(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> $this$defaultChecksumAlgorithmName) {
        Intrinsics.checkNotNullParameter($this$defaultChecksumAlgorithmName, (String)"<this>");
        return (String)$this$defaultChecksumAlgorithmName.getExecutionContext().getOrNull(HttpOperationContext.INSTANCE.getDefaultChecksumAlgorithm());
    }
}

