/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.operation;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.metrics.Histogram;
import aws.smithy.kotlin.runtime.telemetry.metrics.Meter;
import aws.smithy.kotlin.runtime.telemetry.metrics.MonotonicCounter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR!\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u001b\u0010\u0019R!\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0012\u001a\u0004\b\u001d\u0010\u0014R!\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0012\u001a\u0004\b\u001f\u0010\u0014R!\u0010 \u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b \u0010\u0012\u001a\u0004\b!\u0010\u0014R!\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u0012\u001a\u0004\b#\u0010\u0014R!\u0010$\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b$\u0010\u0012\u001a\u0004\b%\u0010\u0014R!\u0010&\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b&\u0010\u0012\u001a\u0004\b'\u0010\u0014R!\u0010(\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00108\u0006\u00a2\u0006\f\n\u0004\b(\u0010\u0012\u001a\u0004\b)\u0010\u0014\u00a8\u0006+"}, d2={"Laws/smithy/kotlin/runtime/http/operation/OperationMetrics;", "", "", "scope", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "provider", "<init>", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;)V", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "getProvider", "()Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "Laws/smithy/kotlin/runtime/telemetry/metrics/Meter;", "meter", "Laws/smithy/kotlin/runtime/telemetry/metrics/Meter;", "Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "", "Laws/smithy/kotlin/runtime/telemetry/metrics/DoubleHistogram;", "rpcCallDuration", "Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "getRpcCallDuration", "()Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "rpcAttempts", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "getRpcAttempts", "()Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "rpcErrors", "getRpcErrors", "rpcAttemptDuration", "getRpcAttemptDuration", "rpcAttemptOverheadDuration", "getRpcAttemptOverheadDuration", "serializationDuration", "getSerializationDuration", "deserializationDuration", "getDeserializationDuration", "resolveEndpointDuration", "getResolveEndpointDuration", "resolveIdentityDuration", "getResolveIdentityDuration", "signingDuration", "getSigningDuration", "Companion", "http-client"})
public final class OperationMetrics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TelemetryProvider provider;
    @NotNull
    private final Meter meter;
    @NotNull
    private final Histogram<Double> rpcCallDuration;
    @NotNull
    private final MonotonicCounter rpcAttempts;
    @NotNull
    private final MonotonicCounter rpcErrors;
    @NotNull
    private final Histogram<Double> rpcAttemptDuration;
    @NotNull
    private final Histogram<Double> rpcAttemptOverheadDuration;
    @NotNull
    private final Histogram<Double> serializationDuration;
    @NotNull
    private final Histogram<Double> deserializationDuration;
    @NotNull
    private final Histogram<Double> resolveEndpointDuration;
    @NotNull
    private final Histogram<Double> resolveIdentityDuration;
    @NotNull
    private final Histogram<Double> signingDuration;
    @NotNull
    private static final OperationMetrics None = new OperationMetrics("NoOp", TelemetryProvider.Companion.getNone());

    public OperationMetrics(@NotNull String scope, @NotNull TelemetryProvider provider) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.meter = this.provider.getMeterProvider().getOrCreateMeter(scope);
        this.rpcCallDuration = this.meter.createDoubleHistogram("smithy.client.call.duration", "s", "Overall call duration including retries");
        this.rpcAttempts = this.meter.createMonotonicCounter("smithy.client.call.attempts", "{attempt}", "The number of attempts for an operation");
        this.rpcErrors = this.meter.createMonotonicCounter("smithy.client.call.errors", "{error}", "The number of errors for an operation");
        this.rpcAttemptDuration = this.meter.createDoubleHistogram("smithy.client.call.attempt_duration", "s", "The time it takes to connect to complete an entire call attempt, including identity resolution, endpoint resolution, signing, sending the request, and receiving the HTTP status code and headers from the response for an operation");
        this.rpcAttemptOverheadDuration = this.meter.createDoubleHistogram("smithy.client.call.attempt_overhead_duration", "s", "The time it takes to execute an attempt minus the time spent waiting for a response from the remote server");
        this.serializationDuration = this.meter.createDoubleHistogram("smithy.client.call.serialization_duration", "s", "The time it takes to serialize a request message body");
        this.deserializationDuration = this.meter.createDoubleHistogram("smithy.client.call.deserialization_duration", "s", "The time it takes to deserialize a response message body");
        this.resolveEndpointDuration = this.meter.createDoubleHistogram("smithy.client.call.resolve_endpoint_duration", "s", "The time it takes to resolve an endpoint for a request");
        this.resolveIdentityDuration = this.meter.createDoubleHistogram("smithy.client.call.auth.resolve_identity_duration", "s", "The time it takes to resolve an identity for signing a request");
        this.signingDuration = this.meter.createDoubleHistogram("smithy.client.call.auth.signing_duration", "s", "The time it takes to sign a request");
    }

    @NotNull
    public final TelemetryProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final Histogram<Double> getRpcCallDuration() {
        return this.rpcCallDuration;
    }

    @NotNull
    public final MonotonicCounter getRpcAttempts() {
        return this.rpcAttempts;
    }

    @NotNull
    public final MonotonicCounter getRpcErrors() {
        return this.rpcErrors;
    }

    @NotNull
    public final Histogram<Double> getRpcAttemptDuration() {
        return this.rpcAttemptDuration;
    }

    @NotNull
    public final Histogram<Double> getRpcAttemptOverheadDuration() {
        return this.rpcAttemptOverheadDuration;
    }

    @NotNull
    public final Histogram<Double> getSerializationDuration() {
        return this.serializationDuration;
    }

    @NotNull
    public final Histogram<Double> getDeserializationDuration() {
        return this.deserializationDuration;
    }

    @NotNull
    public final Histogram<Double> getResolveEndpointDuration() {
        return this.resolveEndpointDuration;
    }

    @NotNull
    public final Histogram<Double> getResolveIdentityDuration() {
        return this.resolveIdentityDuration;
    }

    @NotNull
    public final Histogram<Double> getSigningDuration() {
        return this.signingDuration;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Laws/smithy/kotlin/runtime/http/operation/OperationMetrics$Companion;", "", "<init>", "()V", "Laws/smithy/kotlin/runtime/http/operation/OperationMetrics;", "None", "Laws/smithy/kotlin/runtime/http/operation/OperationMetrics;", "getNone", "()Laws/smithy/kotlin/runtime/http/operation/OperationMetrics;", "http-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OperationMetrics getNone() {
            return None;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

