/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetric;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetricsUtilsKt;
import aws.smithy.kotlin.runtime.businessmetrics.SmithyBusinessMetric;
import aws.smithy.kotlin.runtime.client.Interceptor;
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext;
import aws.smithy.kotlin.runtime.client.ProtocolResponseInterceptorContext;
import aws.smithy.kotlin.runtime.client.RequestInterceptorContext;
import aws.smithy.kotlin.runtime.client.ResponseInterceptorContext;
import aws.smithy.kotlin.runtime.compression.CompressionAlgorithm;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.compression.CompressRequestKt;
import aws.smithy.kotlin.runtime.http.interceptors.RequestCompressionInterceptorKt;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u0005B+\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000fH\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0013R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0014R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0014R\u0018\u0010\u0017\u001a\u00020\u0016*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/RequestCompressionInterceptor;", "Laws/smithy/kotlin/runtime/client/Interceptor;", "", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "Laws/smithy/kotlin/runtime/http/interceptors/HttpInterceptor;", "", "compressionThresholdBytes", "", "Laws/smithy/kotlin/runtime/compression/CompressionAlgorithm;", "availableCompressionAlgorithms", "", "supportedCompressionAlgorithms", "<init>", "(JLjava/util/List;Ljava/util/List;)V", "Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;", "context", "modifyBeforeRetryLoop", "(Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "J", "Ljava/util/List;", "Laws/smithy/kotlin/runtime/http/HttpBody;", "", "isStreaming", "(Laws/smithy/kotlin/runtime/http/HttpBody;)Z", "http-client"})
@SourceDebugExtension(value={"SMAP\nRequestCompressionInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestCompressionInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/RequestCompressionInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n*L\n1#1,66:1\n1#2:67\n1#2:69\n258#3:68\n259#3:70\n*S KotlinDebug\n*F\n+ 1 RequestCompressionInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/RequestCompressionInterceptor\n*L\n51#1:69\n51#1:68\n51#1:70\n*E\n"})
public final class RequestCompressionInterceptor
implements Interceptor<Object, Object, HttpRequest, HttpResponse> {
    private final long compressionThresholdBytes;
    @NotNull
    private final List<CompressionAlgorithm> availableCompressionAlgorithms;
    @NotNull
    private final List<String> supportedCompressionAlgorithms;

    public RequestCompressionInterceptor(long compressionThresholdBytes, @NotNull List<? extends CompressionAlgorithm> availableCompressionAlgorithms, @NotNull List<String> supportedCompressionAlgorithms) {
        Intrinsics.checkNotNullParameter(availableCompressionAlgorithms, (String)"availableCompressionAlgorithms");
        Intrinsics.checkNotNullParameter(supportedCompressionAlgorithms, (String)"supportedCompressionAlgorithms");
        this.compressionThresholdBytes = compressionThresholdBytes;
        this.availableCompressionAlgorithms = availableCompressionAlgorithms;
        this.supportedCompressionAlgorithms = supportedCompressionAlgorithms;
        IntRange intRange = RequestCompressionInterceptorKt.access$getVALID_COMPRESSION_THRESHOLD_BYTES_RANGE$p();
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        long l = this.compressionThresholdBytes;
        if (!((long)n <= l ? l <= (long)n2 : false)) {
            boolean bl = false;
            String string = "compressionThresholdBytes (" + this.compressionThresholdBytes + ") must be in the range " + RequestCompressionInterceptorKt.access$getVALID_COMPRESSION_THRESHOLD_BYTES_RANGE$p();
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object modifyBeforeRetryLoop(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        void $this$logger$iv;
        HttpRequest httpRequest;
        CoroutineContext it;
        String algorithm;
        block10: {
            block11: {
                boolean bl;
                Long payloadSizeBytes;
                block9: {
                    String string;
                    payloadSizeBytes = ((HttpRequest)context.getProtocolRequest()).getBody().getContentLength();
                    for (String id : (Iterable)this.supportedCompressionAlgorithms) {
                        Object v0;
                        block8: {
                            boolean bl2 = false;
                            Iterable iterable = this.availableCompressionAlgorithms;
                            for (Object t : iterable) {
                                CompressionAlgorithm it2 = (CompressionAlgorithm)t;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it2.getId(), (Object)id)) continue;
                                v0 = t;
                                break block8;
                            }
                            v0 = null;
                        }
                        if ((id = (CompressionAlgorithm)v0) == null) continue;
                        string = id;
                        break block9;
                    }
                    string = algorithm = null;
                }
                if (algorithm == null) break block10;
                if (this.isStreaming(((HttpRequest)context.getProtocolRequest()).getBody())) break block11;
                Long l = payloadSizeBytes;
                if (l != null) {
                    long it3 = ((Number)l).longValue();
                    boolean bl4 = false;
                    bl = it3 >= this.compressionThresholdBytes;
                } else {
                    bl = false;
                }
                if (!bl) break block10;
            }
            HttpRequest httpRequest2 = CompressRequestKt.compressRequest(algorithm, (HttpRequest)((HttpRequest)context.getProtocolRequest()));
            it = httpRequest2;
            boolean bl = false;
            BusinessMetricsUtilsKt.emitBusinessMetric((ExecutionContext)context.getExecutionContext(), (BusinessMetric)((BusinessMetric)SmithyBusinessMetric.GZIP_REQUEST_COMPRESSION));
            httpRequest = httpRequest2;
            return httpRequest;
        }
        it = $completion.getContext();
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(RequestCompressionInterceptor.class).getQualifiedName();
        if (string == null) {
            boolean bl = false;
            String string2 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException(string2.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        String skipCause = algorithm == null ? "no modeled compression algorithms are supported by the client" : "request size threshold (" + this.compressionThresholdBytes + ") was not met";
        Logger.DefaultImpls.debug$default((Logger)logger, null, () -> RequestCompressionInterceptor.modifyBeforeRetryLoop$lambda$5(skipCause), (int)1, null);
        httpRequest = (HttpRequest)context.getProtocolRequest();
        return httpRequest;
    }

    private final boolean isStreaming(HttpBody $this$isStreaming) {
        return $this$isStreaming instanceof HttpBody.ChannelContent || $this$isStreaming instanceof HttpBody.SourceContent || $this$isStreaming.getContentLength() == null;
    }

    public void readBeforeExecution(@NotNull RequestInterceptorContext<Object> context) {
        Interceptor.DefaultImpls.readBeforeExecution((Interceptor)this, context);
    }

    @Nullable
    public Object modifyBeforeSerialization(@NotNull RequestInterceptorContext<Object> context, @NotNull Continuation<Object> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeSerialization((Interceptor)this, context, $completion);
    }

    public void readBeforeSerialization(@NotNull RequestInterceptorContext<Object> context) {
        Interceptor.DefaultImpls.readBeforeSerialization((Interceptor)this, context);
    }

    public void readAfterSerialization(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readAfterSerialization((Interceptor)this, context);
    }

    public void readBeforeAttempt(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeAttempt((Interceptor)this, context);
    }

    @Nullable
    public Object modifyBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeSigning((Interceptor)this, context, $completion);
    }

    public void readBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeSigning((Interceptor)this, context);
    }

    public void readAfterSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readAfterSigning((Interceptor)this, context);
    }

    @Nullable
    public Object modifyBeforeTransmit(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeTransmit((Interceptor)this, context, $completion);
    }

    public void readBeforeTransmit(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeTransmit((Interceptor)this, context);
    }

    public void readAfterTransmit(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterTransmit((Interceptor)this, context);
    }

    @Nullable
    public Object modifyBeforeDeserialization(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super HttpResponse> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeDeserialization((Interceptor)this, context, $completion);
    }

    public void readBeforeDeserialization(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readBeforeDeserialization((Interceptor)this, context);
    }

    public void readAfterDeserialization(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterDeserialization((Interceptor)this, context);
    }

    @Nullable
    public Object modifyBeforeAttemptCompletion-gIAlu-s(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super Result<? extends Object>> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeAttemptCompletion-gIAlu-s((Interceptor)this, context, $completion);
    }

    public void readAfterAttempt(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterAttempt((Interceptor)this, context);
    }

    @Nullable
    public Object modifyBeforeCompletion-gIAlu-s(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super Result<? extends Object>> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeCompletion-gIAlu-s((Interceptor)this, context, $completion);
    }

    public void readAfterExecution(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterExecution((Interceptor)this, context);
    }

    private static final String modifyBeforeRetryLoop$lambda$5(String $skipCause) {
        return "skipping request compression because " + $skipCause;
    }
}

