/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.operation;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.SdkClientOption;
import aws.smithy.kotlin.runtime.collections.AttributeKey;
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize;
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer;
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext;
import aws.smithy.kotlin.runtime.http.operation.HttpSerdeKt;
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize;
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer;
import aws.smithy.kotlin.runtime.http.operation.OperationTypeInfo;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation;
import aws.smithy.kotlin.runtime.http.operation.SdkOperationExecution;
import aws.smithy.kotlin.runtime.http.operation.SdkOperationTelemetry;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u001d\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010=R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R<\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00132\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R<\u0010/\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010.2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010.8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b0\u0010\u0016\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\"\"\u0004\b7\u0010$R\u0011\u00108\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Laws/smithy/kotlin/runtime/http/operation/SdkHttpOperationBuilder;", "I", "O", "", "inputType", "Lkotlin/reflect/KClass;", "outputType", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;)V", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "getContext", "()Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "deserializeWith", "Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;", "getDeserializeWith", "()Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;", "setDeserializeWith", "(Laws/smithy/kotlin/runtime/http/operation/HttpDeserializer;)V", "value", "Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;", "deserializer", "getDeserializer$annotations", "()V", "getDeserializer", "()Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;", "setDeserializer", "(Laws/smithy/kotlin/runtime/http/operation/HttpDeserialize;)V", "execution", "Laws/smithy/kotlin/runtime/http/operation/SdkOperationExecution;", "getExecution", "()Laws/smithy/kotlin/runtime/http/operation/SdkOperationExecution;", "hostPrefix", "", "getHostPrefix", "()Ljava/lang/String;", "setHostPrefix", "(Ljava/lang/String;)V", "operationName", "getOperationName", "setOperationName", "serializeWith", "Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;", "getSerializeWith", "()Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;", "setSerializeWith", "(Laws/smithy/kotlin/runtime/http/operation/HttpSerializer;)V", "Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "serializer", "getSerializer$annotations", "getSerializer", "()Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "setSerializer", "(Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;)V", "serviceName", "getServiceName", "setServiceName", "telemetry", "Laws/smithy/kotlin/runtime/http/operation/SdkOperationTelemetry;", "getTelemetry", "()Laws/smithy/kotlin/runtime/http/operation/SdkOperationTelemetry;", "build", "Laws/smithy/kotlin/runtime/http/operation/SdkHttpOperation;", "http-client"})
@SourceDebugExtension(value={"SMAP\nSdkHttpOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkHttpOperation.kt\naws/smithy/kotlin/runtime/http/operation/SdkHttpOperationBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class SdkHttpOperationBuilder<I, O> {
    @NotNull
    private final KClass<?> inputType;
    @NotNull
    private final KClass<?> outputType;
    @NotNull
    private final SdkOperationTelemetry telemetry;
    @Nullable
    private HttpSerialize<I> serializer;
    @Nullable
    private HttpSerializer<I> serializeWith;
    @Nullable
    private HttpDeserialize<O> deserializer;
    @Nullable
    private HttpDeserializer<O> deserializeWith;
    @NotNull
    private final SdkOperationExecution<I, O> execution;
    @NotNull
    private final ExecutionContext context;
    @Nullable
    private String operationName;
    @Nullable
    private String serviceName;
    @Nullable
    private String hostPrefix;

    public SdkHttpOperationBuilder(@NotNull KClass<?> inputType, @NotNull KClass<?> outputType) {
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.inputType = inputType;
        this.outputType = outputType;
        this.telemetry = new SdkOperationTelemetry();
        this.execution = new SdkOperationExecution();
        this.context = new ExecutionContext();
    }

    @NotNull
    public final SdkOperationTelemetry getTelemetry() {
        return this.telemetry;
    }

    @Nullable
    public final HttpSerialize<I> getSerializer() {
        return this.serializer;
    }

    public final void setSerializer(@Nullable HttpSerialize<I> value) {
        this.serializer = value;
        HttpSerialize<I> httpSerialize = value;
        this.serializeWith = httpSerialize != null ? HttpSerdeKt.intoSerializer(httpSerialize) : null;
    }

    @Deprecated(message="use serializeWith")
    public static /* synthetic */ void getSerializer$annotations() {
    }

    @Nullable
    public final HttpSerializer<I> getSerializeWith() {
        return this.serializeWith;
    }

    public final void setSerializeWith(@Nullable HttpSerializer<I> httpSerializer) {
        this.serializeWith = httpSerializer;
    }

    @Nullable
    public final HttpDeserialize<O> getDeserializer() {
        return this.deserializer;
    }

    public final void setDeserializer(@Nullable HttpDeserialize<O> value) {
        this.deserializer = value;
        HttpDeserialize<O> httpDeserialize = value;
        this.deserializeWith = httpDeserialize != null ? HttpSerdeKt.intoDeserializer(httpDeserialize) : null;
    }

    @Deprecated(message="use deserializeWith")
    public static /* synthetic */ void getDeserializer$annotations() {
    }

    @Nullable
    public final HttpDeserializer<O> getDeserializeWith() {
        return this.deserializeWith;
    }

    public final void setDeserializeWith(@Nullable HttpDeserializer<O> httpDeserializer) {
        this.deserializeWith = httpDeserializer;
    }

    @NotNull
    public final SdkOperationExecution<I, O> getExecution() {
        return this.execution;
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    @Nullable
    public final String getOperationName() {
        return this.operationName;
    }

    public final void setOperationName(@Nullable String string) {
        this.operationName = string;
    }

    @Nullable
    public final String getServiceName() {
        return this.serviceName;
    }

    public final void setServiceName(@Nullable String string) {
        this.serviceName = string;
    }

    @Nullable
    public final String getHostPrefix() {
        return this.hostPrefix;
    }

    public final void setHostPrefix(@Nullable String string) {
        this.hostPrefix = string;
    }

    @NotNull
    public final SdkHttpOperation<I, O> build() {
        HttpSerializer<I> httpSerializer = this.serializeWith;
        if (httpSerializer == null) {
            boolean $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opSerializer$22 = false;
            String $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opSerializer$22 = "SdkHttpOperation.serializeWith must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-SdkHttpOperationBuilder$build$opSerializer$22.toString());
        }
        HttpSerializer<I> opSerializer = httpSerializer;
        HttpDeserializer<O> httpDeserializer = this.deserializeWith;
        if (httpDeserializer == null) {
            boolean $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opDeserializer$22 = false;
            String $i$a$-requireNotNull-SdkHttpOperationBuilder$build$opDeserializer$22 = "SdkHttpOperation.deserializeWith must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-SdkHttpOperationBuilder$build$opDeserializer$22.toString());
        }
        HttpDeserializer<O> opDeserializer = httpDeserializer;
        if (this.operationName == null) {
            boolean $i$a$-requireNotNull-SdkHttpOperationBuilder$build$32 = false;
            String $i$a$-requireNotNull-SdkHttpOperationBuilder$build$32 = "operationName is a required HTTP execution attribute";
            throw new IllegalArgumentException($i$a$-requireNotNull-SdkHttpOperationBuilder$build$32.toString());
        }
        if (this.serviceName == null) {
            boolean bl = false;
            String string = "serviceName is a required HTTP execution attribute";
            throw new IllegalArgumentException(string.toString());
        }
        AttributeKey attributeKey = SdkClientOption.INSTANCE.getOperationName();
        String string = this.operationName;
        Intrinsics.checkNotNull((Object)string);
        this.context.set(attributeKey, (Object)string);
        AttributeKey attributeKey2 = SdkClientOption.INSTANCE.getServiceName();
        String string2 = this.serviceName;
        Intrinsics.checkNotNull((Object)string2);
        this.context.set(attributeKey2, (Object)string2);
        String string3 = this.hostPrefix;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            this.context.set(HttpOperationContext.INSTANCE.getHostPrefix(), (Object)it);
        }
        OperationTypeInfo typeInfo = new OperationTypeInfo(this.inputType, this.outputType);
        return new SdkHttpOperation<I, O>(this.execution, this.context, opSerializer, opDeserializer, typeInfo, this.telemetry);
    }
}

