/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext;
import aws.smithy.kotlin.runtime.hashing.Md5Kt;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.interceptors.AbstractChecksumInterceptor;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilderKt;
import aws.smithy.kotlin.runtime.http.request.HttpRequestKt;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B,\u0012%\b\u0002\u0010\u0003\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rH\u0096@\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rH\u0096@\u00a2\u0006\u0002\u0010\u0012R+\u0010\u0003\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/Md5ChecksumInterceptor;", "I", "Laws/smithy/kotlin/runtime/http/interceptors/AbstractChecksumInterceptor;", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "input", "", "(Lkotlin/jvm/functions/Function1;)V", "applyChecksum", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "context", "Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;", "", "checksum", "", "calculateChecksum", "(Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "modifyBeforeSigning", "http-client"})
public final class Md5ChecksumInterceptor<I>
extends AbstractChecksumInterceptor {
    @Nullable
    private final Function1<I, Boolean> block;

    public Md5ChecksumInterceptor(@Nullable Function1<? super I, Boolean> block) {
        this.block = block;
    }

    public /* synthetic */ Md5ChecksumInterceptor(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this(function1);
    }

    @Override
    @Nullable
    public Object modifyBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        boolean injectMd5Header;
        Object input = context.getRequest();
        Function1<I, Boolean> function1 = this.block;
        boolean bl = injectMd5Header = function1 != null ? (Boolean)function1.invoke(input) : true;
        if (!injectMd5Header) {
            return context.getProtocolRequest();
        }
        return super.modifyBeforeSigning(context, $completion);
    }

    @Override
    @Nullable
    public Object calculateChecksum(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super String> $completion) {
        HttpBody body = ((HttpRequest)context.getProtocolRequest()).getBody();
        return body instanceof HttpBody.Bytes ? Base64Kt.encodeBase64String((byte[])Md5Kt.md5((byte[])((HttpBody.Bytes)body).bytes())) : null;
    }

    @Override
    @NotNull
    public HttpRequest applyChecksum(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull String checksum) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        HttpRequestBuilder req = HttpRequestKt.toBuilder((HttpRequest)((HttpRequest)context.getProtocolRequest()));
        if (!req.getHeaders().contains("Content-MD5")) {
            HttpRequestBuilderKt.header((HttpRequestBuilder)req, (String)"Content-MD5", (String)checksum);
        }
        return req.build();
    }

    public Md5ChecksumInterceptor() {
        this(null, 1, null);
    }
}

