/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext;
import aws.smithy.kotlin.runtime.hashing.Crc32;
import aws.smithy.kotlin.runtime.hashing.Crc32c;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HashFunctionKt;
import aws.smithy.kotlin.runtime.hashing.Sha1;
import aws.smithy.kotlin.runtime.hashing.Sha256;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.http.interceptors.AbstractChecksumInterceptor;
import aws.smithy.kotlin.runtime.http.interceptors.FlexibleChecksumsRequestInterceptor;
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilderKt;
import aws.smithy.kotlin.runtime.http.request.HttpRequestKt;
import aws.smithy.kotlin.runtime.io.HashingByteReadChannel;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.SdkSourceJVMKt;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002'(B\u001f\u0012\u0018\b\u0002\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0017J\u0014\u0010\u001a\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J$\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\"H\u0082@\u00a2\u0006\u0002\u0010#J\u001a\u0010$\u001a\u00020\n*\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000bR\u0018\u0010\f\u001a\u00020\t*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006)"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/FlexibleChecksumsRequestInterceptor;", "I", "Laws/smithy/kotlin/runtime/http/interceptors/AbstractChecksumInterceptor;", "checksumAlgorithmNameInitializer", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "checksumAlgorithmName", "isEligibleForAwsChunkedStreaming", "", "Laws/smithy/kotlin/runtime/http/HttpBody;", "(Laws/smithy/kotlin/runtime/http/HttpBody;)Z", "isSupported", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "(Laws/smithy/kotlin/runtime/hashing/HashFunction;)Z", "applyChecksum", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "context", "Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;", "", "checksum", "calculateChecksum", "(Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "modifyBeforeSigning", "readAfterSerialization", "", "removeAllChecksumHeadersExcept", "Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "headerName", "rollingHash", "", "Laws/smithy/kotlin/runtime/io/SdkByteReadChannel;", "hashFunction", "bufferSize", "", "(Laws/smithy/kotlin/runtime/io/SdkByteReadChannel;Laws/smithy/kotlin/runtime/hashing/HashFunction;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toCompletingBody", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "CompletingByteReadChannel", "CompletingSource", "http-client"})
@SourceDebugExtension(value={"SMAP\nFlexibleChecksumsRequestInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlexibleChecksumsRequestInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/FlexibleChecksumsRequestInterceptor\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n258#2:214\n259#2:216\n1#3:215\n1855#4,2:217\n*S KotlinDebug\n*F\n+ 1 FlexibleChecksumsRequestInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/FlexibleChecksumsRequestInterceptor\n*L\n47#1:214\n47#1:216\n47#1:215\n153#1:217,2\n*E\n"})
public final class FlexibleChecksumsRequestInterceptor<I>
extends AbstractChecksumInterceptor {
    @Nullable
    private final Function1<I, String> checksumAlgorithmNameInitializer;
    @Nullable
    private String checksumAlgorithmName;

    public FlexibleChecksumsRequestInterceptor(@Nullable Function1<? super I, String> checksumAlgorithmNameInitializer) {
        this.checksumAlgorithmNameInitializer = checksumAlgorithmNameInitializer;
    }

    public /* synthetic */ FlexibleChecksumsRequestInterceptor(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this(function1);
    }

    @Override
    @Deprecated(message="readAfterSerialization is no longer used")
    public void readAfterSerialization(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object modifyBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        void $this$logger$iv;
        CoroutineContext coroutineContext = $completion.getContext();
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(FlexibleChecksumsRequestInterceptor.class).getQualifiedName();
        if (string == null) {
            boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = false;
            String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        Object input = context.getRequest();
        Object object = this.checksumAlgorithmNameInitializer;
        if (object == null || (object = (String)object.invoke(input)) == null) {
            object = this.checksumAlgorithmName = (String)context.getExecutionContext().getOrNull(HttpOperationContext.INSTANCE.getChecksumAlgorithm());
        }
        if (this.checksumAlgorithmName == null) {
            FlexibleChecksumsRequestInterceptor $this$modifyBeforeSigning_u24lambda_u240 = this;
            boolean bl = false;
            Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)modifyBeforeSigning.2.1.INSTANCE, (int)1, null);
            return context.getProtocolRequest();
        }
        HttpRequestBuilder req = HttpRequestKt.toBuilder((HttpRequest)((HttpRequest)context.getProtocolRequest()));
        if (!(!(((HttpRequest)context.getProtocolRequest()).getBody() instanceof HttpBody.Empty))) {
            boolean $i$a$-check-FlexibleChecksumsRequestInterceptor$modifyBeforeSigning$42 = false;
            String $i$a$-check-FlexibleChecksumsRequestInterceptor$modifyBeforeSigning$42 = "Can't calculate the checksum of an empty body";
            throw new IllegalStateException($i$a$-check-FlexibleChecksumsRequestInterceptor$modifyBeforeSigning$42.toString());
        }
        String string2 = ("x-amz-checksum-" + this.checksumAlgorithmName).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String headerName = string2;
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(headerName){
            final /* synthetic */ String $headerName;
            {
                this.$headerName = $headerName;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Resolved checksum header name: " + this.$headerName;
            }
        }), (int)1, null);
        this.removeAllChecksumHeadersExcept(req.getHeaders(), headerName);
        String string3 = this.checksumAlgorithmName;
        if (string3 == null || (string3 = HashFunctionKt.toHashFunction((String)string3)) == null) {
            throw new ClientException("Could not parse checksum algorithm " + this.checksumAlgorithmName);
        }
        String checksumAlgorithm = string3;
        if (!this.isSupported((HashFunction)checksumAlgorithm)) {
            throw new ClientException("Checksum algorithm " + this.checksumAlgorithmName + " is not supported for flexible checksums");
        }
        if (this.isEligibleForAwsChunkedStreaming(req.getBody())) {
            HttpRequestBuilderKt.header((HttpRequestBuilder)req, (String)"x-amz-trailer", (String)headerName);
            CompletableDeferred deferredChecksum = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)context.getExecutionContext().getCoroutineContext()));
            if (req.getHeaders().get(headerName) != null) {
                Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)modifyBeforeSigning.5.INSTANCE, (int)1, null);
                Object object2 = req.getHeaders().get(headerName);
                Intrinsics.checkNotNull((Object)object2);
                String checksum = (String)object2;
                req.getHeaders().remove(headerName);
                deferredChecksum.complete((Object)checksum);
            } else {
                Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)modifyBeforeSigning.6.INSTANCE, (int)1, null);
                req.setBody(this.toCompletingBody(HttpBodyKt.toHashingBody((HttpBody)req.getBody(), (HashFunction)checksumAlgorithm, (Long)req.getBody().getContentLength()), (CompletableDeferred<String>)deferredChecksum));
            }
            req.getTrailingHeaders().append(headerName, (Object)deferredChecksum);
            return req.build();
        }
        return super.modifyBeforeSigning(context, $completion);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object calculateChecksum(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> var1_1, @NotNull Continuation<? super String> var2_2) {
        if (!(var2_2 instanceof calculateChecksum.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FlexibleChecksumsRequestInterceptor<I> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.calculateChecksum(null, (Continuation<String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                req = HttpRequestKt.toBuilder((HttpRequest)((HttpRequest)context.getProtocolRequest()));
                v0 = this.checksumAlgorithmName;
                if (v0 == null || (v0 = HashFunctionKt.toHashFunction((String)v0)) == null) {
                    return null;
                }
                checksumAlgorithm /* !! */  = v0;
                if (req.getBody().getContentLength() != null || req.getBody().isOneShot()) break;
                v1 = HttpBodyKt.toSdkByteReadChannel$default((HttpBody)req.getBody(), null, (int)1, null);
                Intrinsics.checkNotNull((Object)v1);
                channel = v1;
                $continuation.label = 1;
                v2 = FlexibleChecksumsRequestInterceptor.rollingHash$default(this, channel, checksumAlgorithm /* !! */ , 0L, (Continuation)$continuation, 2, null);
                if (v2 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl30:
                // 2 sources

                v3 = Base64Kt.encodeBase64String((byte[])((byte[])v2));
                ** GOTO lbl48
            }
        }
        $continuation.L$0 = req;
        $continuation.L$1 = checksumAlgorithm /* !! */ ;
        $continuation.label = 2;
        v4 = HttpBodyKt.readAll((HttpBody)req.getBody(), (Continuation)$continuation);
        if (v4 == var8_5) {
            return var8_5;
        }
        ** GOTO lbl44
        {
            case 2: {
                checksumAlgorithm /* !! */  = (HashFunction)$continuation.L$1;
                req = (HttpRequestBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl44:
                // 2 sources

                Intrinsics.checkNotNull((Object)v4);
                bodyBytes = (byte[])v4;
                req.setBody(HttpBodyKt.toHttpBody((byte[])bodyBytes));
                v3 = Base64Kt.encodeBase64String((byte[])HashFunctionKt.hash((byte[])bodyBytes, (HashFunction)checksumAlgorithm /* !! */ ));
lbl48:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public HttpRequest applyChecksum(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull String checksum) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        String string = ("x-amz-checksum-" + this.checksumAlgorithmName).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String headerName = string;
        HttpRequestBuilder req = HttpRequestKt.toBuilder((HttpRequest)((HttpRequest)context.getProtocolRequest()));
        if (!req.getHeaders().contains(headerName)) {
            HttpRequestBuilderKt.header((HttpRequestBuilder)req, (String)headerName, (String)checksum);
        }
        return req.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEligibleForAwsChunkedStreaming(HttpBody $this$isEligibleForAwsChunkedStreaming) {
        if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.SourceContent)) {
            if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.ChannelContent)) return false;
        }
        if ($this$isEligibleForAwsChunkedStreaming.getContentLength() == null) return false;
        if ($this$isEligibleForAwsChunkedStreaming.isOneShot()) return true;
        Long l = $this$isEligibleForAwsChunkedStreaming.getContentLength();
        Intrinsics.checkNotNull((Object)l);
        if (l <= 0x100000L) return false;
        return true;
    }

    private final boolean isSupported(HashFunction $this$isSupported) {
        HashFunction hashFunction = $this$isSupported;
        return ((hashFunction instanceof Crc32 ? true : hashFunction instanceof Crc32c) ? true : hashFunction instanceof Sha256) ? true : hashFunction instanceof Sha1;
    }

    private final void removeAllChecksumHeadersExcept(HeadersBuilder $this$removeAllChecksumHeadersExcept, String headerName) {
        Iterable $this$forEach$iv = $this$removeAllChecksumHeadersExcept.names();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)name, (String)"x-amz-checksum-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)headerName)) continue;
            $this$removeAllChecksumHeadersExcept.remove(name);
        }
    }

    private final HttpBody toCompletingBody(HttpBody $this$toCompletingBody, CompletableDeferred<String> deferred) {
        HttpBody httpBody;
        HttpBody httpBody2 = $this$toCompletingBody;
        if (httpBody2 instanceof HttpBody.SourceContent) {
            SdkSource sdkSource = ((HttpBody.SourceContent)$this$toCompletingBody).readFrom();
            Intrinsics.checkNotNull((Object)sdkSource, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.io.HashingSource");
            httpBody = HttpBodyKt.toHttpBody((SdkSource)new CompletingSource(deferred, (HashingSource)sdkSource), (Long)$this$toCompletingBody.getContentLength());
        } else if (httpBody2 instanceof HttpBody.ChannelContent) {
            SdkByteReadChannel sdkByteReadChannel = ((HttpBody.ChannelContent)$this$toCompletingBody).readFrom();
            Intrinsics.checkNotNull((Object)sdkByteReadChannel, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.io.HashingByteReadChannel");
            httpBody = HttpBodyKt.toHttpBody((SdkByteReadChannel)new CompletingByteReadChannel(deferred, (HashingByteReadChannel)sdkByteReadChannel), (Long)$this$toCompletingBody.getContentLength());
        } else {
            throw new ClientException("HttpBody type is not supported");
        }
        return httpBody;
    }

    /*
     * Unable to fully structure code
     */
    private final Object rollingHash(SdkByteReadChannel var1_1, HashFunction var2_2, long var3_3, Continuation<? super byte[]> var5_4) {
        if (!(var5_4 instanceof rollingHash.1)) ** GOTO lbl-1000
        var9_5 = var5_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ FlexibleChecksumsRequestInterceptor<I> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FlexibleChecksumsRequestInterceptor.access$rollingHash(this.this$0, null, null, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                buffer = new SdkBuffer();
lbl13:
                // 2 sources

                while (!$this$rollingHash.isClosedForRead()) {
                    $continuation.L$0 = $this$rollingHash;
                    $continuation.L$1 = hashFunction;
                    $continuation.L$2 = buffer;
                    $continuation.L$3 = null;
                    $continuation.J$0 = bufferSize;
                    $continuation.label = 1;
                    v0 = $this$rollingHash.read(buffer, bufferSize, (Continuation)$continuation);
                    if (v0 == var10_7) {
                        return var10_7;
                    }
                    ** GOTO lbl32
                }
                break;
            }
            case 1: {
                bufferSize = $continuation.J$0;
                buffer = (SdkBuffer)$continuation.L$2;
                hashFunction = (HashFunction)$continuation.L$1;
                $this$rollingHash = (SdkByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                var7_9 = hashFunction;
                $continuation.L$0 = $this$rollingHash;
                $continuation.L$1 = hashFunction;
                $continuation.L$2 = buffer;
                $continuation.L$3 = var7_9;
                $continuation.J$0 = bufferSize;
                $continuation.label = 2;
                v1 = SdkSourceJVMKt.readToByteArray((SdkSource)((SdkSource)buffer), (Continuation)$continuation);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl51
            }
            case 2: {
                bufferSize = $continuation.J$0;
                var7_9 = (HashFunction)$continuation.L$3;
                buffer = (SdkBuffer)$continuation.L$2;
                hashFunction = (HashFunction)$continuation.L$1;
                $this$rollingHash = (SdkByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl51:
                // 2 sources

                HashFunction.DefaultImpls.update$default((HashFunction)var7_9, (byte[])((byte[])v1), (int)0, (int)0, (int)6, null);
                ** GOTO lbl13
            }
        }
        return hashFunction.digest();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object rollingHash$default(FlexibleChecksumsRequestInterceptor flexibleChecksumsRequestInterceptor, SdkByteReadChannel sdkByteReadChannel, HashFunction hashFunction, long l, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            l = 8192L;
        }
        return flexibleChecksumsRequestInterceptor.rollingHash(sdkByteReadChannel, hashFunction, l, (Continuation<byte[]>)continuation);
    }

    public FlexibleChecksumsRequestInterceptor() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Object access$rollingHash(FlexibleChecksumsRequestInterceptor $this, SdkByteReadChannel $receiver, HashFunction hashFunction, long bufferSize, Continuation $completion) {
        return $this.rollingHash($receiver, hashFunction, bufferSize, (Continuation<byte[]>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0096\u0001J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u001bR\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001c"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/FlexibleChecksumsRequestInterceptor$CompletingByteReadChannel;", "Laws/smithy/kotlin/runtime/io/SdkByteReadChannel;", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "hashingChannel", "Laws/smithy/kotlin/runtime/io/HashingByteReadChannel;", "(Lkotlinx/coroutines/CompletableDeferred;Laws/smithy/kotlin/runtime/io/HashingByteReadChannel;)V", "availableForRead", "", "getAvailableForRead", "()I", "closedCause", "", "getClosedCause", "()Ljava/lang/Throwable;", "isClosedForRead", "", "()Z", "isClosedForWrite", "cancel", "cause", "read", "", "sink", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "limit", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "http-client"})
    public static final class CompletingByteReadChannel
    implements SdkByteReadChannel {
        @NotNull
        private final CompletableDeferred<String> deferred;
        @NotNull
        private final HashingByteReadChannel hashingChannel;

        public CompletingByteReadChannel(@NotNull CompletableDeferred<String> deferred, @NotNull HashingByteReadChannel hashingChannel) {
            Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)hashingChannel, (String)"hashingChannel");
            this.deferred = deferred;
            this.hashingChannel = hashingChannel;
        }

        public int getAvailableForRead() {
            return this.hashingChannel.getAvailableForRead();
        }

        @Nullable
        public Throwable getClosedCause() {
            return this.hashingChannel.getClosedCause();
        }

        public boolean isClosedForRead() {
            return this.hashingChannel.isClosedForRead();
        }

        public boolean isClosedForWrite() {
            return this.hashingChannel.isClosedForWrite();
        }

        public boolean cancel(@Nullable Throwable cause) {
            return this.hashingChannel.cancel(cause);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object read(@NotNull SdkBuffer var1_1, long var2_2, @NotNull Continuation<? super Long> var4_3) {
            if (!(var4_3 instanceof read.1)) ** GOTO lbl-1000
            var10_4 = var4_3;
            if ((var10_4.label & -2147483648) != 0) {
                var10_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ CompletingByteReadChannel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.read(null, 0L, (Continuation<? super Long>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.hashingChannel.read((SdkBuffer)sink, (long)limit, (Continuation)$continuation);
                    if (v0 == var11_6) {
                        return var11_6;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (CompletingByteReadChannel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    var5_7 = v0;
                    it = ((Number)var5_7).longValue();
                    $i$a$-also-FlexibleChecksumsRequestInterceptor$CompletingByteReadChannel$read$2 = false;
                    if (it == -1L) {
                        this.deferred.complete((Object)Base64Kt.encodeBase64String((byte[])this.hashingChannel.digest()));
                    }
                    return var5_7;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/FlexibleChecksumsRequestInterceptor$CompletingSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "hashingSource", "Laws/smithy/kotlin/runtime/io/HashingSource;", "(Lkotlinx/coroutines/CompletableDeferred;Laws/smithy/kotlin/runtime/io/HashingSource;)V", "close", "", "read", "", "sink", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "limit", "http-client"})
    public static final class CompletingSource
    implements SdkSource {
        @NotNull
        private final CompletableDeferred<String> deferred;
        @NotNull
        private final HashingSource hashingSource;

        public CompletingSource(@NotNull CompletableDeferred<String> deferred, @NotNull HashingSource hashingSource) {
            Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)hashingSource, (String)"hashingSource");
            this.deferred = deferred;
            this.hashingSource = hashingSource;
        }

        public void close() {
            this.hashingSource.close();
        }

        public long read(@NotNull SdkBuffer sink, long limit) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            long it = l = this.hashingSource.read(sink, limit);
            boolean bl = false;
            if (it == -1L) {
                this.deferred.complete((Object)Base64Kt.encodeBase64String((byte[])this.hashingSource.digest()));
            }
            return l;
        }
    }
}

