/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine;

import aws.smithy.kotlin.runtime.http.engine.EnvironmentProxySelectorKt;
import aws.smithy.kotlin.runtime.http.engine.NonProxyHost;
import aws.smithy.kotlin.runtime.http.engine.ProxyConfig;
import aws.smithy.kotlin.runtime.http.engine.ProxySelector;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.util.EnvironmentProvider;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import aws.smithy.kotlin.runtime.util.PropertyProvider;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector;", "Laws/smithy/kotlin/runtime/http/engine/ProxySelector;", "provider", "Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;", "(Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;)V", "httpProxy", "Laws/smithy/kotlin/runtime/http/engine/ProxyConfig;", "getHttpProxy", "()Laws/smithy/kotlin/runtime/http/engine/ProxyConfig;", "httpProxy$delegate", "Lkotlin/Lazy;", "httpsProxy", "getHttpsProxy", "httpsProxy$delegate", "nonProxyHosts", "", "Laws/smithy/kotlin/runtime/http/engine/NonProxyHost;", "getNonProxyHosts", "()Ljava/util/Set;", "nonProxyHosts$delegate", "nonProxy", "", "url", "Laws/smithy/kotlin/runtime/net/url/Url;", "select", "http-client"})
@SourceDebugExtension(value={"SMAP\nEnvironmentProxySelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentProxySelector.kt\naws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1747#2,3:157\n*S KotlinDebug\n*F\n+ 1 EnvironmentProxySelector.kt\naws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector\n*L\n50#1:157,3\n*E\n"})
public final class EnvironmentProxySelector
implements ProxySelector {
    @NotNull
    private final Lazy httpProxy$delegate;
    @NotNull
    private final Lazy httpsProxy$delegate;
    @NotNull
    private final Lazy nonProxyHosts$delegate;

    public EnvironmentProxySelector(@NotNull PlatformEnvironProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.httpProxy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProxyConfig>(provider){
            final /* synthetic */ PlatformEnvironProvider $provider;
            {
                this.$provider = $provider;
                super(0);
            }

            @Nullable
            public final ProxyConfig invoke() {
                ProxyConfig proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByProperty((PropertyProvider)this.$provider, Scheme.Companion.getHTTP());
                if (proxyConfig == null) {
                    proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByEnvironment((EnvironmentProvider)this.$provider, Scheme.Companion.getHTTP());
                }
                return proxyConfig;
            }
        }));
        this.httpsProxy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProxyConfig>(provider){
            final /* synthetic */ PlatformEnvironProvider $provider;
            {
                this.$provider = $provider;
                super(0);
            }

            @Nullable
            public final ProxyConfig invoke() {
                ProxyConfig proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByProperty((PropertyProvider)this.$provider, Scheme.Companion.getHTTPS());
                if (proxyConfig == null) {
                    proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByEnvironment((EnvironmentProvider)this.$provider, Scheme.Companion.getHTTPS());
                }
                return proxyConfig;
            }
        }));
        this.nonProxyHosts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends NonProxyHost>>(provider){
            final /* synthetic */ PlatformEnvironProvider $provider;
            {
                this.$provider = $provider;
                super(0);
            }

            @NotNull
            public final Set<NonProxyHost> invoke() {
                return EnvironmentProxySelectorKt.access$resolveNonProxyHosts(this.$provider);
            }
        }));
    }

    public /* synthetic */ EnvironmentProxySelector(PlatformEnvironProvider platformEnvironProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            platformEnvironProvider = (PlatformEnvironProvider)PlatformProvider.Companion.getSystem();
        }
        this(platformEnvironProvider);
    }

    private final ProxyConfig getHttpProxy() {
        Lazy lazy = this.httpProxy$delegate;
        return (ProxyConfig)lazy.getValue();
    }

    private final ProxyConfig getHttpsProxy() {
        Lazy lazy = this.httpsProxy$delegate;
        return (ProxyConfig)lazy.getValue();
    }

    private final Set<NonProxyHost> getNonProxyHosts() {
        Lazy lazy = this.nonProxyHosts$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public ProxyConfig select(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.getHttpProxy() == null && this.getHttpsProxy() == null || this.nonProxy(url)) {
            return ProxyConfig.Direct.INSTANCE;
        }
        Scheme scheme = url.getScheme();
        ProxyConfig proxyConfig = Intrinsics.areEqual((Object)scheme, (Object)Scheme.Companion.getHTTP()) ? this.getHttpProxy() : (Intrinsics.areEqual((Object)scheme, (Object)Scheme.Companion.getHTTPS()) ? this.getHttpsProxy() : null);
        ProxyConfig proxyConfig2 = proxyConfig;
        if (proxyConfig2 == null) {
            proxyConfig2 = ProxyConfig.Direct.INSTANCE;
        }
        return proxyConfig2;
    }

    private final boolean nonProxy(Url url) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getNonProxyHosts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NonProxyHost it = (NonProxyHost)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public EnvironmentProxySelector() {
        this(null, 1, null);
    }
}

