/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine;

import aws.smithy.kotlin.runtime.http.engine.EnvironmentProxySelectorKt;
import aws.smithy.kotlin.runtime.http.engine.NoProxyHost;
import aws.smithy.kotlin.runtime.http.engine.ProxyConfig;
import aws.smithy.kotlin.runtime.http.engine.ProxySelector;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.util.EnvironmentProvider;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import aws.smithy.kotlin.runtime.util.PropertyProvider;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector;", "Laws/smithy/kotlin/runtime/http/engine/ProxySelector;", "provider", "Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;", "(Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;)V", "httpProxy", "Laws/smithy/kotlin/runtime/http/engine/ProxyConfig;", "httpsProxy", "noProxyHosts", "", "Laws/smithy/kotlin/runtime/http/engine/NoProxyHost;", "noProxy", "", "url", "Laws/smithy/kotlin/runtime/net/url/Url;", "select", "http-client"})
@SourceDebugExtension(value={"SMAP\nEnvironmentProxySelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentProxySelector.kt\naws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1747#2,3:153\n*S KotlinDebug\n*F\n+ 1 EnvironmentProxySelector.kt\naws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector\n*L\n51#1:153,3\n*E\n"})
public final class EnvironmentProxySelector
implements ProxySelector {
    @Nullable
    private final ProxyConfig httpProxy;
    @Nullable
    private final ProxyConfig httpsProxy;
    @NotNull
    private final Set<NoProxyHost> noProxyHosts;

    public EnvironmentProxySelector(@NotNull PlatformEnvironProvider provider) {
        ProxyConfig proxyConfig;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ProxyConfig proxyConfig2 = EnvironmentProxySelectorKt.access$resolveProxyByProperty((PropertyProvider)provider, Scheme.Companion.getHTTP());
        if (proxyConfig2 == null) {
            proxyConfig2 = this.httpProxy = EnvironmentProxySelectorKt.access$resolveProxyByEnvironment((EnvironmentProvider)provider, Scheme.Companion.getHTTP());
        }
        if ((proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByProperty((PropertyProvider)provider, Scheme.Companion.getHTTPS())) == null) {
            proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByEnvironment((EnvironmentProvider)provider, Scheme.Companion.getHTTPS());
        }
        this.httpsProxy = proxyConfig;
        this.noProxyHosts = EnvironmentProxySelectorKt.access$resolveNoProxyHosts(provider);
    }

    public /* synthetic */ EnvironmentProxySelector(PlatformEnvironProvider platformEnvironProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            platformEnvironProvider = (PlatformEnvironProvider)PlatformProvider.Companion.getSystem();
        }
        this(platformEnvironProvider);
    }

    @Override
    @NotNull
    public ProxyConfig select(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.httpProxy == null && this.httpsProxy == null || this.noProxy(url)) {
            return ProxyConfig.Direct.INSTANCE;
        }
        Scheme scheme = url.getScheme();
        ProxyConfig proxyConfig = Intrinsics.areEqual((Object)scheme, (Object)Scheme.Companion.getHTTP()) ? this.httpProxy : (Intrinsics.areEqual((Object)scheme, (Object)Scheme.Companion.getHTTPS()) ? this.httpsProxy : null);
        ProxyConfig proxyConfig2 = proxyConfig;
        if (proxyConfig2 == null) {
            proxyConfig2 = ProxyConfig.Direct.INSTANCE;
        }
        return proxyConfig2;
    }

    private final boolean noProxy(Url url) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.noProxyHosts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NoProxyHost it = (NoProxyHost)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public EnvironmentProxySelector() {
        this(null, 1, null);
    }
}

