/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.client.Interceptor;
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext;
import aws.smithy.kotlin.runtime.client.ProtocolResponseInterceptorContext;
import aws.smithy.kotlin.runtime.client.RequestInterceptorContext;
import aws.smithy.kotlin.runtime.client.ResponseInterceptorContext;
import aws.smithy.kotlin.runtime.http.engine.EngineAttributes;
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.telemetry.context.Context;
import aws.smithy.kotlin.runtime.telemetry.metrics.HistogramKt;
import aws.smithy.kotlin.runtime.util.Attributes;
import aws.smithy.kotlin.runtime.util.AttributesBuilder;
import aws.smithy.kotlin.runtime.util.AttributesKt;
import aws.smithy.kotlin.runtime.util.MutableAttributes;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u0005B'\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ*\u0010\u0017\u001a\u00020\u00182 \u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00182\u001e\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u001aH\u0016J,\u0010\u001c\u001a\u00020\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001aH\u0016J\u001c\u0010\u001d\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001eH\u0016J\"\u0010 \u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040!H\u0016J\u0016\u0010\"\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0016J\u0016\u0010$\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/OperationTelemetryInterceptor;", "Laws/smithy/kotlin/runtime/client/Interceptor;", "", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "Laws/smithy/kotlin/runtime/http/interceptors/HttpInterceptor;", "metrics", "Laws/smithy/kotlin/runtime/http/operation/OperationMetrics;", "service", "", "operation", "timeSource", "Lkotlin/time/TimeSource;", "(Laws/smithy/kotlin/runtime/http/operation/OperationMetrics;Ljava/lang/String;Ljava/lang/String;Lkotlin/time/TimeSource;)V", "attemptStart", "Lkotlin/time/TimeMark;", "attempts", "", "callStart", "deserializeStart", "perRpcAttributes", "Laws/smithy/kotlin/runtime/util/Attributes;", "serializeStart", "readAfterAttempt", "", "context", "Laws/smithy/kotlin/runtime/client/ResponseInterceptorContext;", "readAfterDeserialization", "readAfterExecution", "readAfterSerialization", "Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;", "readBeforeAttempt", "readBeforeDeserialization", "Laws/smithy/kotlin/runtime/client/ProtocolResponseInterceptorContext;", "readBeforeExecution", "Laws/smithy/kotlin/runtime/client/RequestInterceptorContext;", "readBeforeSerialization", "http-client"})
@SourceDebugExtension(value={"SMAP\nOperationTelemetryInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperationTelemetryInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/OperationTelemetryInterceptor\n+ 2 Attributes.kt\naws/smithy/kotlin/runtime/util/AttributesKt\n*L\n1#1,118:1\n207#2:119\n190#2:120\n190#2:121\n*S KotlinDebug\n*F\n+ 1 OperationTelemetryInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/OperationTelemetryInterceptor\n*L\n44#1:119\n44#1:120\n71#1:121\n*E\n"})
public final class OperationTelemetryInterceptor
implements Interceptor<Object, Object, HttpRequest, HttpResponse> {
    @NotNull
    private final OperationMetrics metrics;
    @NotNull
    private final String service;
    @NotNull
    private final String operation;
    @NotNull
    private final TimeSource timeSource;
    @Nullable
    private TimeMark callStart;
    @Nullable
    private TimeMark serializeStart;
    @Nullable
    private TimeMark deserializeStart;
    @Nullable
    private TimeMark attemptStart;
    private int attempts;
    @NotNull
    private final Attributes perRpcAttributes;

    /*
     * WARNING - void declaration
     */
    public OperationTelemetryInterceptor(@NotNull OperationMetrics metrics, @NotNull String service, @NotNull String operation, @NotNull TimeSource timeSource) {
        void $this$perRpcAttributes_u24lambda_u240;
        AttributesBuilder attributesBuilder;
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.metrics = metrics;
        this.service = service;
        this.operation = operation;
        this.timeSource = timeSource;
        boolean $i$f$attributesOf = false;
        boolean $i$f$mutableAttributesOf = false;
        AttributesBuilder attributesBuilder2 = attributesBuilder = new AttributesBuilder();
        OperationTelemetryInterceptor operationTelemetryInterceptor = this;
        boolean bl = false;
        $this$perRpcAttributes_u24lambda_u240.to("rpc.service", (Object)this.service);
        $this$perRpcAttributes_u24lambda_u240.to("rpc.method", (Object)this.operation);
        operationTelemetryInterceptor.perRpcAttributes = (Attributes)attributesBuilder.getAttributes();
    }

    public /* synthetic */ OperationTelemetryInterceptor(OperationMetrics operationMetrics, String string, String string2, TimeSource timeSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        this(operationMetrics, string, string2, timeSource);
    }

    public void readBeforeExecution(@NotNull RequestInterceptorContext<Object> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.callStart = this.timeSource.markNow();
    }

    public void readAfterExecution(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        block5: {
            Attributes attributes;
            Object object;
            long it;
            Object object2;
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Context currentCtx = this.metrics.getProvider().getContextManager().current();
            TimeMark timeMark = this.callStart;
            if (timeMark != null) {
                long callDuration = timeMark.elapsedNow-UwyO8pc();
                boolean bl = false;
                HistogramKt.recordSeconds-dWUq8MI(this.metrics.getRpcCallDuration(), (long)callDuration, (Attributes)this.perRpcAttributes, (Context)currentCtx);
            }
            if ((object2 = (HttpRequest)context.getProtocolRequest()) != null && (object2 = object2.getBody()) != null && (object2 = object2.getContentLength()) != null) {
                it = ((Number)object2).longValue();
                boolean bl = false;
                this.metrics.getRpcRequestSize().record((Number)it, this.perRpcAttributes, currentCtx);
            }
            if ((object = (HttpResponse)context.getProtocolResponse()) != null && (object = object.getBody()) != null && (object = object.getContentLength()) != null) {
                it = ((Number)object).longValue();
                boolean bl2 = false;
                this.metrics.getRpcResponseSize().record((Number)it, this.perRpcAttributes, currentCtx);
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)context.getResponse-d1pmJ48());
            if (throwable == null) break block5;
            Throwable ex = throwable;
            boolean bl = false;
            String exType = Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName();
            if (exType != null) {
                MutableAttributes mutableAttributes;
                AttributesBuilder bl2;
                boolean $i$f$mutableAttributesOf = false;
                AttributesBuilder $this$readAfterExecution_u24lambda_u246_u24lambda_u244 = bl2 = new AttributesBuilder();
                boolean bl3 = false;
                $this$readAfterExecution_u24lambda_u246_u24lambda_u244.to("exception.type", (Object)exType);
                MutableAttributes it2 = mutableAttributes = bl2.getAttributes();
                boolean bl4 = false;
                AttributesKt.merge((MutableAttributes)it2, (Attributes)this.perRpcAttributes);
                attributes = (Attributes)mutableAttributes;
            } else {
                attributes = this.perRpcAttributes;
            }
            Attributes errorAttributes = attributes;
            this.metrics.getRpcErrors().add(1L, errorAttributes, currentCtx);
        }
    }

    public void readBeforeSerialization(@NotNull RequestInterceptorContext<Object> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.serializeStart = this.timeSource.markNow();
    }

    public void readAfterSerialization(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        TimeMark timeMark = this.serializeStart;
        if (timeMark == null) {
            return;
        }
        long serializeDuration = timeMark.elapsedNow-UwyO8pc();
        HistogramKt.recordSeconds-dWUq8MI(this.metrics.getSerializationDuration(), (long)serializeDuration, (Attributes)this.perRpcAttributes, (Context)this.metrics.getProvider().getContextManager().current());
    }

    public void readAfterAttempt(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        block2: {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            this.metrics.getRpcAttempts().add(1L, this.perRpcAttributes, this.metrics.getProvider().getContextManager().current());
            int n = this.attempts;
            this.attempts = n + 1;
            if (this.attempts > 1) {
                this.metrics.getRpcRetryCount().add(1L, this.perRpcAttributes, this.metrics.getProvider().getContextManager().current());
            }
            TimeMark timeMark = this.attemptStart;
            if (timeMark == null) {
                return;
            }
            long attemptDuration = timeMark.elapsedNow-UwyO8pc();
            HistogramKt.recordSeconds-dWUq8MI(this.metrics.getRpcAttemptDuration(), (long)attemptDuration, (Attributes)this.perRpcAttributes, (Context)this.metrics.getProvider().getContextManager().current());
            Duration duration = (Duration)AttributesKt.takeOrNull((MutableAttributes)((MutableAttributes)context.getExecutionContext()), EngineAttributes.INSTANCE.getTimeToFirstByte());
            if (duration == null) break block2;
            long ttfb = duration.unbox-impl();
            boolean bl = false;
            HistogramKt.recordSeconds-dWUq8MI$default(this.metrics.getRpcAttemptOverheadDuration(), (long)Duration.minus-LRDsOJo((long)attemptDuration, (long)ttfb), (Attributes)this.perRpcAttributes, null, (int)4, null);
        }
    }

    public void readBeforeDeserialization(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.deserializeStart = this.timeSource.markNow();
    }

    public void readAfterDeserialization(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        TimeMark timeMark = this.deserializeStart;
        if (timeMark == null) {
            return;
        }
        long deserializeDuration = timeMark.elapsedNow-UwyO8pc();
        HistogramKt.recordSeconds-dWUq8MI(this.metrics.getDeserializationDuration(), (long)deserializeDuration, (Attributes)this.perRpcAttributes, (Context)this.metrics.getProvider().getContextManager().current());
    }

    public void readBeforeAttempt(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.attemptStart = this.timeSource.markNow();
    }

    @Nullable
    public Object modifyBeforeAttemptCompletion-gIAlu-s(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super Result<? extends Object>> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeAttemptCompletion-gIAlu-s((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeCompletion-gIAlu-s(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super Result<? extends Object>> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeCompletion-gIAlu-s((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeDeserialization(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super HttpResponse> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeDeserialization((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeRetryLoop(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeRetryLoop((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeSerialization(@NotNull RequestInterceptorContext<Object> context, @NotNull Continuation<Object> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeSerialization((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeSigning((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeTransmit(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeTransmit((Interceptor)this, context, $completion);
    }

    public void readAfterSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readAfterSigning((Interceptor)this, context);
    }

    public void readAfterTransmit(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterTransmit((Interceptor)this, context);
    }

    public void readBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeSigning((Interceptor)this, context);
    }

    public void readBeforeTransmit(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeTransmit((Interceptor)this, context);
    }
}

