/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class ExceptionHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HEADER = "----";
    private static final String EXCEPTION = "---- exception report ";
    private static final String COMPOSITE = "---- composite report ";
    private static final String RUNTIME = "---- runtime exception report ";
    private static final String ERROR = "---- error report ";
    private static final String CAUSE = "---- cause ";
    private static final String TRACE = "---- stack trace ";
    private static final String END = "";
    private static final int WIDTH = 80;

    public static String packException(Throwable e) {
        return ExceptionHelper.packException(null, e);
    }

    public static String packException(Throwable e, boolean stack) {
        return ExceptionHelper.packException(null, e, stack);
    }

    public static String packException(String message, Throwable e) {
        return ExceptionHelper.packException(message, e, false);
    }

    public static String packException(String message, Throwable e, boolean stack) {
        StringBuffer buffer = new StringBuffer();
        ExceptionHelper.packException(buffer, 0, message, e, stack);
        buffer.append(ExceptionHelper.getLine(END));
        return buffer.toString();
    }

    public static String packException(String message, Throwable[] e, boolean stack) {
        String lead = "---- composite report (" + e.length + " entries) ";
        StringBuffer buffer = new StringBuffer(ExceptionHelper.getLine(lead));
        if (null != message) {
            buffer.append(message);
            buffer.append("\n");
        }
        for (int i = 0; i < e.length; ++i) {
            ExceptionHelper.packException(buffer, i + 1, null, e[i], stack);
        }
        buffer.append(ExceptionHelper.getLine(END));
        return buffer.toString();
    }

    private static void packException(StringBuffer buffer, int j, String message, Throwable e, boolean stack) {
        if (e instanceof Error) {
            buffer.append(ExceptionHelper.getLine(ERROR, j));
        } else if (e instanceof RuntimeException) {
            buffer.append(ExceptionHelper.getLine(RUNTIME, j));
        } else {
            buffer.append(ExceptionHelper.getLine(EXCEPTION, j));
        }
        if (null != message) {
            buffer.append(message);
            buffer.append("\n");
        }
        if (e == null) {
            return;
        }
        buffer.append("Exception: " + e.getClass().getName() + "\n");
        buffer.append("Message: " + e.getMessage() + "\n");
        ExceptionHelper.packCause(buffer, ExceptionHelper.getCause(e)).toString();
        Throwable root = ExceptionHelper.getLastThrowable(e);
        if (root != null && stack) {
            buffer.append(ExceptionHelper.getLine(TRACE));
            String[] trace = ExceptionHelper.captureStackTrace(root);
            for (int i = 0; i < trace.length; ++i) {
                buffer.append(trace[i] + "\n");
            }
        }
    }

    private static StringBuffer packCause(StringBuffer buffer, Throwable cause) {
        if (cause == null) {
            return buffer;
        }
        buffer.append(ExceptionHelper.getLine(CAUSE));
        buffer.append("Exception: " + cause.getClass().getName() + "\n");
        buffer.append("Message: " + cause.getMessage() + "\n");
        return ExceptionHelper.packCause(buffer, ExceptionHelper.getCause(cause));
    }

    private static Throwable getLastThrowable(Throwable exception) {
        Throwable cause = ExceptionHelper.getCause(exception);
        if (cause != null) {
            return ExceptionHelper.getLastThrowable(cause);
        }
        return exception;
    }

    private static Throwable getCause(Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        try {
            Method method = exception.getClass().getMethod("getCause", new Class[0]);
            return (Throwable)method.invoke((Object)exception, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return ExceptionHelper.splitString(sw.toString(), LINE_SEPARATOR);
    }

    private static String[] splitString(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            String token = tokenizer.nextToken();
            result[i] = token.startsWith("\tat ") ? token.substring(4) : token;
        }
        return result;
    }

    private static String getLine(String lead) {
        return ExceptionHelper.getLine(lead, 0);
    }

    private static String getLine(String lead, int count) {
        StringBuffer buffer = new StringBuffer(lead);
        int q = 0;
        if (count > 0) {
            String v = END + count + " ";
            buffer.append(END + count);
            buffer.append(" ");
            q = v.length() + 1;
        }
        int j = 80 - (lead.length() + q);
        for (int i = 0; i < j; ++i) {
            buffer.append("-");
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

