/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.defaults;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.avalon.util.defaults.Defaults;
import org.apache.avalon.util.defaults.DefaultsFinder;
import org.apache.avalon.util.defaults.SimpleDefaultsFinder;
import org.apache.avalon.util.defaults.SystemDefaultsFinder;
import org.apache.avalon.util.env.Env;

public class DefaultsBuilder {
    private final String m_key;
    private final File m_work;
    private final File m_root;
    private final Properties m_home;
    private final Properties m_user;
    private final Properties m_dir;

    public static File getHomeDirectory(String key) throws IOException {
        String symbol;
        String homeKey = key + ".home";
        String home = System.getProperty(homeKey, Env.getEnvVariable(symbol = key.toUpperCase() + "_HOME"));
        if (null != home) {
            return new File(home).getCanonicalFile();
        }
        File user = new File(System.getProperty("user.home"));
        String path = "." + key;
        return new File(user, path).getCanonicalFile();
    }

    public static Properties getHomeProperties(File home, String key, boolean flag) throws IOException {
        Properties properties = DefaultsBuilder.getProperties(home, key);
        if (flag) {
            String name = key + ".home";
            String path = home.getCanonicalPath();
            properties.setProperty(name, path);
        }
        return properties;
    }

    public static Properties getUserProperties(String key) throws IOException {
        File user = new File(System.getProperty("user.home"));
        return DefaultsBuilder.getProperties(user, key);
    }

    public static Properties getProperties(File dir, String key) throws IOException {
        String filename = key + ".properties";
        File file = new File(dir, filename);
        return DefaultsBuilder.getProperties(file);
    }

    public static Properties getProperties(File file) throws IOException {
        if (null == file) {
            throw new NullPointerException("file");
        }
        Properties properties = new Properties();
        if (file.exists()) {
            properties.load(new FileInputStream(file));
        }
        return properties;
    }

    public static Properties getProperties(ClassLoader classloader, String path) throws IOException {
        Properties properties = new Properties();
        InputStream input = classloader.getResourceAsStream(path);
        if (input != null) {
            properties.load(input);
        }
        return properties;
    }

    public DefaultsBuilder(String key, File work) throws IOException {
        this.m_key = key;
        this.m_work = work;
        this.m_root = DefaultsBuilder.getHomeDirectory(this.m_key);
        this.m_home = DefaultsBuilder.getHomeProperties(this.m_root, this.m_key, true);
        this.m_user = DefaultsBuilder.getUserProperties(this.m_key);
        this.m_dir = DefaultsBuilder.getProperties(this.m_work, this.m_key);
    }

    public File getHomeDirectory() {
        return this.m_root;
    }

    public Properties getHomeProperties() {
        return this.m_home;
    }

    public Properties getUserProperties() {
        return this.m_user;
    }

    public Properties getDirProperties() {
        return this.m_dir;
    }

    public Properties getConsolidatedProperties(Properties defaults, String[] keys) throws IOException {
        return this.getConsolidatedProperties(defaults, keys, new String[0]);
    }

    public Properties getConsolidatedProperties(Properties defaults, String[] keys, String[] sequence) throws IOException {
        Properties[] parameters = new Properties[]{defaults, this.m_home, this.m_user, this.m_dir};
        DefaultsFinder[] finders = new DefaultsFinder[]{new SimpleDefaultsFinder(parameters, false), new SystemDefaultsFinder()};
        return new Defaults(keys, sequence, finders);
    }
}

